<?php

class Crossroads_Retain24_Model_Sales_Order_Total_Creditmemo_Retain24 extends Mage_Sales_Model_Order_Creditmemo_Total_Abstract
{
    public function collect(Mage_Sales_Model_Order_Creditmemo $creditmemo)
    {
        $order = $creditmemo->getOrder();

        // Refund the difference between already refunded and invoiced
        $amount     = $order->getRetain24AmountInvoiced() - $order->getRetain24AmountRefunded();
        $baseAmount = $order->getBaseRetain24AmountInvoiced() - $order->getRetain24AmountRefunded();

        $creditmemo->setGrandTotal($creditmemo->getGrandTotal() + $amount);
        $creditmemo->setBaseGrandTotal($creditmemo->getBaseGrandTotal() + $baseAmount);

        // Make sure we also add the specific amounts
        $creditmemo->setRetain24Amount($amount);
        $creditmemo->setBaseRetain24Amount($baseAmount);
        $creditmemo->setRetain24Code($order->getRetain24Code());

        return $this;
    }
}