<?php

declare(strict_types=1);

use MageQL\ClientException;
use GraphQL\Error\ClientAware;

class Crossroads_Retain24_ProductCategoryDisallowedException
    extends ClientException
    implements ClientAware {
    public function __construct() {
        parent::__construct("Product not in allowed list of categories");
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "retain24";
    }

    public function getExtensions(): array {
        return [
            "code" => "retain24_product_category_disallowed",
        ];
    }
}
