<?php

class Crossroads_Retain24_Model_Resource_Voucher_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract {

    protected function _construct()
    {
        parent::_construct();

        $this->_init("Crossroads_Retain24/voucher");
    }

    public function addItemFilter($itemId)
    {
        /**
         * SELECT
         *     v.*,
         *     i.image_hash
         * FROM crossroads_retain24_voucher v
         * LEFT JOIN crossroads_retain24_voucher_image i ON i.voucher_id = v.entity_id
         * WHERE v.item_id = $itemId
         * 
         */

        $this->getSelect()->joinLeft(
                ["voucher_image" => "crossroads_retain24_voucher_image"],
                "main_table.entity_id = voucher_image.voucher_id",
                ["image_hash"]
        );
        $this->getSelect()->where("main_table.item_id = ?", $itemId);

        return $this;
    }

    public function addOrderFilter($orderId)
    {
        $this->getSelect()->join(
                ["sfoi" => "sales_flat_order_item"],
                "main_table.item_id = sfoi.item_id",
                ["order_id" => "parent_id"]
        );
        $this->getSelect()->where("sfoi.parent_id = ?", $orderId);

        return $this;
    }

}
