<?php

class Crossroads_Retain24_Model_Validation extends Mage_Core_Model_Abstract {

    const TYPE_UNSPECIFIED = "UNSPECIFIED";
    const TYPE_GIFT_CARD = "GIFT_CARD";
    const TYPE_COUPON = "COUPON";
    const TYPE_BONUS_VOUCHER = "BONUS_VOUCHER";
    const TYPE_CREDIT_NOTE = "CREDIT_NOTE";
    const TYPE_BONUS_CARD = "BONUS_CARD";
    const TYPE_PREPAID_CARD = "PREPAID_CARD";

    protected function _construct()
    {
        $this->_init("Crossroads_Retain24/validation");
    }

    public function codeType()
    {
        switch ($this->getCodeType()) {
            case 0:
                return self::TYPE_UNSPECIFIED;
            case 1:
                return self::TYPE_GIFT_CARD;
            case 2:
                return self::TYPE_COUPON;
            case 3:
                return self::TYPE_BONUS_VOUCHER;
            case 4:
                return self::TYPE_CREDIT_NOTE;
            case 5:
                return self::TYPE_BONUS_CARD;
            case 6:
                return self::TYPE_PREPAID_CARD;
            default:
                return null;
        }
    }

}
