<?php

$installer = $this;
$setup = Mage::getResourceModel('catalog/setup', 'catalog_setup');
$entityTypeId = (int) Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();
$DefaultAttributeSetId = (int) $installer->getEntityTypeId('catalog_product', 'Default');

$installer->startSetup();
$conn = $installer->getConnection();

$newAttributeSetId = 0;
$newAttributeSetName = 'Retain24';
$newAttributeGroupName = 'Retain24';

// https://makandracards.com/magento/6721-product-attribute-addition
$newAttributes = array(
    Crossroads_Retain24_Helper_Data::VOUCHER_PRODUCT => array(
        'label' => 'Activate Retain24 processing',
        'group' => '',
        'sort_order' => 1,
        'backend' => '',
        'type' => 'int',
        'frontend' => '',
        'note' => 'This should only be applied to bundle parent if it contains virtual Retain24 product.',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'select',
        'input_renderer' => '',
        'source' => 'eav/entity_attribute_source_boolean',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => true,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'bundle,virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_TEMPLATE => array(
        'label' => 'Retain24 Template ID',
        'group' => '',
        'sort_order' => 2,
        'backend' => '',
        'type' => 'varchar',
        'frontend' => '',
        'note' => '',
        'default' => '',
        'wysiwyg_enabled' => false,
        'input' => 'text',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_DYNAMIC => array(
        'label' => 'Voucher have dynamic value',
        'group' => '',
        'sort_order' => 3,
        'backend' => '',
        'type' => 'int',
        'frontend' => '',
        'note' => 'When active, min and max values below is used ONLY when "Actual value for voucher" is 0.',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'select',
        'input_renderer' => '',
        'source' => 'eav/entity_attribute_source_boolean',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => true,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_REQUIRE_PIN => array(
        'label' => 'Voucher requires PIN when redeemed',
        'group' => '',
        'sort_order' => 4,
        'backend' => '',
        'type' => 'int',
        'frontend' => '',
        'note' => 'PIN is always received, but only used when template requres it.',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'select',
        'input_renderer' => '',
        'source' => 'eav/entity_attribute_source_boolean',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => true,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_MIN => array(
        'label' => 'Minimum value for dynamic voucher',
        'group' => '',
        'sort_order' => 5,
        'backend' => '',
        'type' => 'decimal',
        'frontend' => '',
        'note' => '',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'price',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_MAX => array(
        'label' => 'Maximum value for dynamic voucher',
        'group' => '',
        'sort_order' => 6,
        'backend' => '',
        'type' => 'decimal',
        'frontend' => '',
        'note' => '',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'price',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_VALUE => array(
        'label' => 'Actual value for voucher',
        'group' => '',
        'sort_order' => 7,
        'backend' => '',
        'type' => 'decimal',
        'frontend' => '',
        'note' => 'Usually used for fixed price vouchers. If used for dynamic vouchers, min and max values is NOT used.',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'price',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    //retain24_value_multiplier
    Crossroads_Retain24_Helper_Data::VOUCHER_MULTIPLIER => array(
        'label' => 'Multiplier for value of voucher',
        'group' => '',
        'sort_order' => 8,
        'backend' => '',
        'type' => 'decimal',
        'frontend' => '',
        'note' => 'Multiplier to calculate correct amount/qty when purchasing voucher. See VALUE field from Retain24.',
        'default' => 1,
        'wysiwyg_enabled' => false,
        'input' => 'text',
        'class' => 'validate-number',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_STEPS => array(
        'label' => 'Value steps',
        'group' => '',
        'sort_order' => 9,
        'backend' => '',
        'type' => 'varchar',
        'frontend' => '',
        'note' => 'Comma separated list of pre-defined values. Use "dynamic" for generic input field. If left empty, only generic input field is shown.',
        'default' => '',
        'wysiwyg_enabled' => false,
        'input' => 'text',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_VALID_TO => array(
        'label' => 'Valid to (date or days)',
        'group' => '',
        'sort_order' => 10,
        'backend' => '',
        'type' => 'varchar',
        'frontend' => '',
        'note' => 'Either fixed full date (yyyy-mm-dd) or days from purchase of voucher.',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'text',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_SALES_END => array(
        'label' => 'Sales end',
        'group' => '',
        'sort_order' => 11,
        'backend' => '',
        'type' => 'datetime',
        'frontend' => '',
        'note' => 'Latest possible sale date for this voucher.',
        'default' => '',
        'wysiwyg_enabled' => false,
        'input' => 'date',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_USAGE_START => array(
        'label' => 'Redeemable from',
        'group' => '',
        'sort_order' => 12,
        'backend' => '',
        'type' => 'datetime',
        'frontend' => '',
        'note' => 'Voucher can be redeemed from this date.',
        'default' => '',
        'wysiwyg_enabled' => false,
        'input' => 'date',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_DISTRIBUTION => array(
        'label' => 'Distribution method',
        'group' => '',
        'sort_order' => 13,
        'backend' => '',
        'type' => 'int',
        'frontend' => '',
        'note' => '',
        'default' => '',
        'wysiwyg_enabled' => false,
        'input' => 'select',
        'input_renderer' => '',
        'source' => 'Crossroads_Retain24/Product_Attribute_Distribution',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_EMAIL_TEMPLATE => array(
        'label' => 'Delivery Email Template',
        'group' => '',
        'sort_order' => 14,
        'backend' => '',
        'type' => 'varchar',
        'frontend' => '',
        'note' => 'Template to use for delivering codes to customer.',
        'default' => '',
        'wysiwyg_enabled' => false,
        'input' => 'select',
        'input_renderer' => '',
        'source' => 'Crossroads_Retain24/Product_Email_Template',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => false,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Retain24_Helper_Data::VOUCHER_EMAIL_BCC => array(
        'label' => 'Email Blind Copy To',
        'group' => '',
        'sort_order' => 15,
        'backend' => '',
        'type' => 'varchar',
        'frontend' => '',
        'note' => 'Separate each provided email address with comma.',
        'default' => '',
        'wysiwyg_enabled' => false,
        'input' => 'text',
        'input_renderer' => '',
        'source' => '',
        'class' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => false,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
);

$table = $conn->newTable($installer->getTable("Crossroads_Retain24/voucher"))
    ->addColumn(
        "entity_id",
        Varien_Db_Ddl_Table::TYPE_INTEGER,
        null,
        [
            "auto_increment" => true,
            "identity" => true,
            "unsigned" => true,
            "nullable" => false,
            "primary" => true
        ],
        "Voucher id"
    )
    ->addColumn(
        "item_id",
        Varien_Db_Ddl_Table::TYPE_INTEGER,
        null,
            [
                "unsigned" => true,
                "nullable" => false
            ],
        "sales_flat_order_item id (child item)"
    )
    ->addColumn(
        "voucher_template_id",
        Varien_Db_Ddl_Table::TYPE_TEXT,
        255,
        [
            "nullable" => false
        ],
        "Retain24 template id (TEMPLATE)"
    )
    ->addColumn(
        "voucher_distribution",
        Varien_Db_Ddl_Table::TYPE_INTEGER,
        null,
            [
                "unsigned" => true,
                "nullable" => false
            ],
        "Retain24 distribution (CHANNEL_CODE)"
    )
    ->addColumn(
        "voucher_value",
        Varien_Db_Ddl_Table::TYPE_DECIMAL,
        null,
        [
            "nullable" => false,
            "precision" => 10,
            "scale" => 2
        ],
        "Retain24 value (VALUE and USAGELIMIT)"
    )
    ->addColumn(
        "voucher_id",
        Varien_Db_Ddl_Table::TYPE_TEXT,
        255,
        [
            "nullable" => false
        ],
        "Retain24 id (ID)"
    )
    ->addColumn(
        "voucher_code",
        Varien_Db_Ddl_Table::TYPE_TEXT,
        255,
        [
            "nullable" => false
        ],
        "Retain24 code (MULTICODE)"
    )
    ->addColumn(
        "voucher_pin",
        Varien_Db_Ddl_Table::TYPE_TEXT,
        50,
        [
            "nullable" => true,
            "default" => null
        ],
        "Retain24 pin (PIN)"
    )
    ->addColumn(
        "valid_to",
        Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
        null,
        [
            "nullable" => true,
            "default" => null
        ],
        "Retain24 valid to (USAGEEND or USAGEPERIOD)"
    )
    ->addColumn(
        "created_at",
        Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
        null,
        [
            "nullable" => false,
            "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT
        ]
    )
    ->addColumn(
        "sent_at",
        Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
        null,
        [
            "nullable" => true,
            "default" => null
        ],
        "When voucher was sent to customer"
    )
    ->addForeignKey(
        $installer->getFkName("Crossroads_Retain24/voucher", "item_id", "sales/order_item", "item_id"),
        "item_id",
        $installer->getTable("sales/order_item"),
        "item_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");
$conn->createTable($table);

// Create new attribute set
$attributeSet = Mage::getModel('eav/entity_attribute_set')
    ->setEntityTypeId($entityTypeId)
    ->setAttributeSetName($newAttributeSetName);

if ($attributeSet->validate()) {
    // Need to save empty attribute set to be able to use its id further down the install process
    $attributeSet->save();

    // Add all attributes from default attribute set.
    $attributeSet->initFromSkeleton($DefaultAttributeSetId);

    // Now we can do a final save
    $attributeSet->save();

    // Fetch id for newly created attribute set
    $newAttributeSetId = $this->getAttributeSetId($entityTypeId, $newAttributeSetName);

    // Create new attribute group
    $setup->addAttributeGroup($entityTypeId, $newAttributeSetId, $newAttributeGroupName);

    // Add all new attributes
    foreach ($newAttributes as $attributeName => $attributeData) {

        // Check if attribute already exists
        if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

            // Add attribute
            $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

            // Add new attribute to new attribute set using new attribute group
            $setup->addAttributeToSet($entityTypeId, $newAttributeSetId, $newAttributeGroupName, $attributeName, $attributeData['sort_order']);
        }
    }

} else {
    Mage::log("Attributeset with name '{$newAttributeSetName}' already exists.", LOG_ERR);
}

// Magento setup adds new attributes to ALL existing attribute sets, but NOT to the newly created one, that actually is the ONLY one we wanted them to belong to :-(
// This removes new attributes from all attribute sets EXCEPT the newly created one.
if (!empty($newAttributeSetId)) {
    $sqlQuery1 = "DELETE FROM eav_entity_attribute WHERE attribute_set_id != :attributeSetId AND attribute_id IN (SELECT attribute_id FROM eav_attribute WHERE attribute_code LIKE '%retain24%')";
    $stm1 = Mage::getSingleton('core/resource')->getConnection('core_setup')->prepare($sqlQuery1);
    $stm1->execute(['attributeSetId' => $newAttributeSetId]);
}

// Having problems with is_user_defined not beeing set. This fixes that.
$sqlQuery2 = "UPDATE eav_attribute SET is_user_defined = 1 WHERE attribute_code LIKE '%retain24%'";
$stm2 = Mage::getSingleton('core/resource')->getConnection('core_setup')->prepare($sqlQuery2);
$stm2->execute();

$installer->endSetup();
