# Retain24 Voucher Payment and Purchase
Module for using Retain24 vouchers as payment and purchase of Retain24 vouchers, for Magento 1.x

## Installation instructions

**This module requires module `Crossroads/serialcodes` to be installed!**

After install, do the following:
* Copy the API-certificate files from Retain24 to `/etc/ssl/retain24/` on each server handling API-calls.<br>
  Use pem-format and name the public key `crt.pem` and the private key `key.pem`.
* In Magento Admin edit the `Retain24` attribute set and add attributes `gift_card_text` and `gift_card_terms` to the bottom of the attribute group called `Retain24`.
* Edit the source file `/app/design/adminhtml/default/default/template/serialcodes/order/view/items.phtml` and add this row to the end:
  
  ```php
  <?php echo $this->getChildHtml('retain24.vouchers') ?>
  ```
  For example, after edit, that file from [Magento6/staging](https://groot.crossroads.se/magento/Magento6/blob/staging/app/design/adminhtml/default/default/template/serialcodes/order/view/items.phtml) contains:
  ```php
  <?php $_order = $this->getOrder() ?>
  <?php echo $this->getChildHtml('serialcodes_order_items_table') ?>
  <div class="clear"></div>
  <?php echo $this->getChildHtml('serialcodes_info') ?>
  <?php echo $this->getChildHtml('retain24.vouchers') ?>
  ```

## Magento product setup

List available templates and get data for the wanted one.
At he moment only a test controller in staging is used to fetch raw data.
[templatelist](https://magento6-staging.crossroads.se/retain24/test/templatelist/)
* `ID`
  Template ID is hopfully self describing.
* `NAME`
  Can be used to name the product.
* `MAXAMOUNT`
  Maximum amount of "vouchers" this template allows.
* `SALESEND`
  Last date any new "voucher" can be sold from this template.
* `USAGESTART`
  Earliest date when "voucher" can be redeemed.
* `USAGEEND`
  Last date when "voucher" can be redeemed.
* `USAGEPERIOD`
  How many days the "voucher" is valid OR fixed date when "voucher" expires.
* `USAGELIMIT`
  Limit for individual "voucher", in units. To get value, multiply by `VALUE`
* `CUSTOM_USAGE`
  A "1" here indicates that value is user defined, otherwise predifined amout is used.
* `PRICE`
  The price per "voucher", if `USAGELIMIT` is purchased.
* `VALUE`
  The value of each unit.
* `CURRENCY`
  The prefined currency for all "vouchers" in this template.
* `CHANNEL_CODE`
  Usually this is supposed be a "4", meaning external distribution (means that we, Crossroads, is supposed to give the customer the code however we se fit)

When creating a new product using the above values, the following attributes specific to Retain24 can be set as follows:
* `Activate Retain24 processing`: Self explaining...
* `Retain24 Template ID`: uses `ID`.
* `Voucher have dynamic value`: reflects `CUSTOM_USAGE`.
* `Minimum value for voucher`: can be used as min value when `CUSTOM_USAGE` = "1".
* `Maximum value for voucher`: can be used as max value when `CUSTOM_USAGE` = "1".<br>
* `Actual value for voucher`: when `CUSTOM_USAGE` = "0" then value usually comes from `PRICE`,<br>
  but sometimes from `USAGELIMIT` multiplied by `VALUE`.<br>
  When `CUSTOM_USAGE` = "1" a value > 0 makes voucher behave as having a fixed value
* `Multiplier for value of voucher`: calculated as 1 / `VALUE`.
* `Value steps`: Only used when `CUSTOM_USAGE` = "1".<br>
  A comma separated list of predefined values for user to select from.<br>
  If it has a value of "dynamic", user can enter any value between `Minimum value for voucher` and `Maximum value for voucher`.
* `Valid to (date or days)`: comes from `USAGEPERIOD`.
* `Sales end`: comes from `SALESEND`.
* `Redeemable from`: comes from `USAGESTART`.
* `Distribution method`: comes from `CHANNEL_CODE`.
* `Delivery Email Template`: select email template to use when sending "voucher" to customer.
* `Email Blind Copy To`: email address to someone who is supposed to receive a copy of the customer email.
* `Gift Card Text`: specific text for this "voucher", sent in customer email.
* `Gift Card Terms`: specific terms for this "voucher", sent in customer email.

Price:
* `Price` is to be set as `VALUE` multiplied by `Multiplier for value of voucher`.
  Usually one of two cases exists.
  * If `VALUE` is 1, `Multiplier for value of voucher` should also be 1, then `Price` becomes 1.
  * If `VALUE` is 0.01, `Multiplier for value of voucher` should be 100, then `Price` becomes 1.
* Other values can be set, especially if `CUSTOM_USAGE` is != "1".<br>
  Make sure the price actually corresponds to the correct value purchased from Retain24.

## Crossroads Magento API

Considerations for attributes needed by frontend. All attributes is extracted from voucher product, unless otherwise stated.
* Need to know if the product is a Retain24 "voucher".<br>
  Fetch this from `is_retain24_product` attribute on product.
* Voucher is "truly dynamic" when `retain24_dynamic` = 1 AND `retain24_value` = 0 (or empty)<br>
  **Please remember that all truly dynamic vouchers are bundles**
* Need to know if value needs user input.<br>
  User input is only needed if voucher is truly dynamic<br>
  AND `retain24_value_steps` contains at least 2 values or the value "dynamic.<br>
  IF the value "dynamic" exists in list, user should be presented with free input field.<br>
  Value entered by customer must be between `retain24_min_value` and `retain24_max_value`.<br>
  **Please remember that all truly dynamic vouchers are bundles**
* If voucher is truly dynamic, qty of child product is used as value.<br>
  **Please remember that qty of parent product can also be set.**
* The user should be presented with `retain24_valid_to` and `retain24_usage_start`.<br>
  `retain24_valid_to` can contain date OR days from purchase.<br>
  If it contains days, perhaps a date should be calculated before presentation?
* Perhaps `gift_card_terms` should also be shown?

## Examples

Template 1 have these values from Retain24
* `USAGELIMIT` = 1000
* `CUSTOM_USAGE` = 1
* `PRICE` = 1000
* `VALUE` = 1

Product 1 is based on Template 1 and have these values in Magento
* `Voucher have dynamic value`: Yes (comes from `CUSTOM_USAGE`)
* `Minimum value for voucher`: 100
* `Maximum value for voucher`: 1000 (comes from `USAGELIMIT`)
* `Value steps`: 100,250,500,750,1000,dynamic
* `Actual value for voucher`: 0
* `Price` 1

Product 1 is rendered as having dropdown with values 100,250,500,750,1000 and free input field where values between 100 and 1000 is accepted.<br>
Product is a bundle and `qty` of child is used to transfer value from dropdown or free input field when placed in cart.<br>
Price is calculated and presented as `qty` from child multiplied by `price` from child.<br>
**Please observe: Bundles have NO support for customer group prices**

Product 2 is also based on Template 1 and have these values in Magento
* `Voucher have dynamic value`: Yes (comes from `CUSTOM_USAGE`)
* `Minimum value for voucher`: 0
* `Maximum value for voucher`: 0
* `Value steps`: (empty)
* `Actual value for voucher`: 500
* `Price` 500

Product 2 is rendered as having no user input for value.<br>
Product can technically be simple OR bundle, but as `Price` > 1kr it's much better to keep it simple...<br>
otherwise actual price in cart can become too high.<br>
`Actual value for voucher` can be used on frontend to show the value.<br>
**Please observe 1: Bundles have NO support for customer group prices**<br>
**Please observe 2: Be mindfull how sale price is calculated if `Price` > 1, when product is a bundle**

Template 2 have these values from Retain24
* `USAGELIMIT` = 50000
* `CUSTOM_USAGE` = 0
* `PRICE` = 50000
* `VALUE` = 0.01

Product 3 is based on Template 2 and have these values in Magento
* `Voucher have dynamic value`: No (comes from `CUSTOM_USAGE`)
* `Minimum value for voucher`: 0
* `Maximum value for voucher`: 0
* `Value steps`: (empty)
* `Actual value for voucher`: 500
* `Multiplier for value of voucher`: 100
* `Price` is set to 500kr

Product 3 is rendered as having no user input for value.<br>
Product is always a simple product.<br>
Since `VALUE` is != 1, `Multiplier for value of voucher` must be set.<br>
`Actual value for voucher` can be used on frontend to show the value.