<?php

$installer = $this;
$setup = Mage::getResourceModel('catalog/setup', 'catalog_setup');

$installer->startSetup();
$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("Crossroads_Retain24/voucher_image"))
    ->addColumn(
        "voucher_id",
        Varien_Db_Ddl_Table::TYPE_INTEGER,
        null,
        [
            "auto_increment" => false,
            "identity" => true,
            "unsigned" => true,
            "nullable" => false,
            "primary" => true
        ],
        "Voucher id"
    )
    ->addColumn(
        "image_hash",
        Varien_Db_Ddl_Table::TYPE_TEXT,
        null,
        [
            "nullable" => false
        ],
        "Image data"
    )
    ->addColumn(
        "image_data",
        Varien_Db_Ddl_Table::TYPE_BLOB,
        null,
        [
            "nullable" => false
        ],
        "Image data"
    )
    ->addForeignKey(
        $installer->getFkName("Crossroads_Retain24/voucher_image", "voucher_id", "Crossroads_Retain24/voucher", "entity_id"),
        "voucher_id",
        $installer->getTable("Crossroads_Retain24/voucher"),
        "entity_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE
    )
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");
$conn->createTable($table);

// Varien_Db_Ddl_Table::TYPE_TEXT is too large, we only need 32 chars
// Varien_Db_Ddl_Table::TYPE_BLOB is too small, we need to change image_data to MEDIUMBLOB
$sqlQuery1 = "
    ALTER TABLE `crossroads_retain24_voucher_image`
        CHANGE COLUMN `image_hash` `image_hash` VARCHAR(32) NOT NULL,
        CHANGE COLUMN `image_data` `image_data` MEDIUMBLOB NOT NULL
";
$stm1 = Mage::getSingleton('core/resource')->getConnection('core_setup')->prepare($sqlQuery1);
$stm1->execute();

$installer->endSetup();
