<?php

class Crossroads_Retain24_Retain24Controller extends Mage_Core_Controller_Front_Action {

    // Testdata
    const CODE = "0119961838626258";
    const PIN = 06720;
    const AMOUNT = 1;

    // Called by: /_auc/retain24/get_image/hash/<hash>.png
    public function get_imageAction()
    {
        Mage::helper("Retain24/Image")->getImage($this->getRequest()->getParams());
    }

    // Called by: /_auc/retain24/recreate_image/id/<voucher_id>
    public function recreate_imageAction()
    {
        Mage::helper('integration')->checkIP();

        Mage::helper("Retain24/Image")->recreateImage($this->getRequest()->getParams());

        http_response_code(200);
        die("Ok");
    }

    // Called by: /_auc/retain24/save_qr_image/code/<render_code>[/show/{1|0}]
    public function save_qr_imageAction()
    {
        require_once(Mage::getBaseDir("lib") . "/phpqrcode/qrlib.php");
        http_response_code(200);

        $params = $this->getRequest()->getParams();
        if (empty($params["code"])) {
            die("No code!");
        }

        $renderCode = $params["code"];
        try {
            $path = Mage::getBaseDir("media") . "/barcodes";
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }
            $fileName = "{$path}/{$renderCode}.png";

            QRcode::png($renderCode, $fileName, QR_ECLEVEL_L, 8);

            if (!empty($params["show"])) {
                $imageData = file_get_contents($fileName);
                header('Content-type: image/png');
                header("Content-Length: " . filesize($fileName));
                header("Content-Disposition: filename={$renderCode}.png");
                echo $imageData;
                exit;
            }

        } catch (Exception $exception) {
            die($exception->getMessage());
        }

        echo "OK";
        exit;
    }

    // Run by: /_auc/retain24/test/
    public function testAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();

        die("Crossroads_Retain24_Retain24_TestController::indexAction()");

        $helper = Mage::helper("Retain24");
        $store = Mage::app()->getStore();

        // Validate Code
        $response = $helper->validate($store, self::CODE);

        if (empty($response)) {
            throw new Exception("Validation error.");
        }

        $validation_id = $response["ID"];
        echo "<b>Validate code</b>";
        echo "<pre>";
        print_r($response);
        echo "</pre>";

        // Reserve amount on code
        $response = $helper->reserve_instance($store, $validation_id, self::AMOUNT, self::PIN);
        $reference_id = $response["REFERENCE"];
        echo "<b>Reserve amount</b>";
        echo "<pre>";
        print_r($response);
        echo "</pre>";

        // Validate reservation
        $response = $helper->validate_reservation($store, $reference_id);
        echo "<b>Validate reservation</b>";
        echo "<pre>";
        print_r($response);
        echo "</pre>";

        // Append /redeem to url to redeem reserved amount. Else cancel reservation.
        if (array_key_exists("redeem", $this->getRequest()->getParams())) {
            // Redeem reservation
            $response = $helper->redeem_reservation($store, $reference_id, $validation_id, self::AMOUNT);
            echo "<b>Redeem reservation</b>";
            echo "<pre>";
            print_r($response);
            echo "</pre>";
        } else {
            // Cancel reservation
            $response = $helper->cancel_reservation($store, $reference_id);
            echo "<b>Cancel reservation</b>";
            echo "<pre>";
            print_r($response);
            echo "</pre>";
        }

        echo "Validation ID: {$validation_id}<br>";
        echo "Reference ID: {$reference_id}<br>";
    }

    // Run by: /_auc/retain24/test_product
    public function test_productAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::productAction()");

        $storeId = intval(Mage::app()->getStore()->getStoreId());
        $productId = 13032; // 	Retain24 presentkort fixed value 100
        //$productId = 13034; // Retain24 presentkort dynamic value 100 - 5000

        $product = Mage::getModel('catalog/product')->setStoreId($storeId)->load($productId);
        if ($product->getIsRetain24Product()) {
            $collection = $product->getTypeInstance(true)->getSelectionsCollection($product->getTypeInstance(true)->getOptionsIds($product), $product);
            foreach ($collection as $item) {
                echo '<pre>' . print_r($item->getData(), true) . '</pre>';
            }
        }

        //$data = $product->getData();
        $data = [];
        echo '<pre>' . print_r($data, true) . '</pre>';
    }

    // Run by: /_auc/retain24/test_voucher/
    public function test_voucherAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::voucherAction()");

        if (false) {
            $voucher = Mage::getModel("Crossroads_Retain24/voucher");
            $newData = [
                'item_id' => 394081,
                'template_id' => "1701",
                'validation_id' => "abc123",
                'value' => 47.11,
                'currency' => "SEK",
                'code' => "1234567890abcdefghijk",
                'valid_to' => "2020-12-31"
            ];
            $voucher->addData($newData);
            $voucher->save();
        }
        if (false) {
            $voucher = Mage::getModel("Crossroads_Retain24/voucher");
            $voucher->load(1);
            $dataBefore = $voucher->getData();
            echo('<pre>Before:' . print_r($dataBefore, true) . '</pre>');
            $voucher->testAction();
            $dataAfter = $voucher->getData();
            echo('<pre>After:' . print_r($dataAfter, true) . '</pre>');
        }

        die("done!");
    }

    // Run by: /_auc/retain24/test_attribute/
    public function test_attributeAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::attributeAction()");

        if (false) {
            $setup = Mage::getResourceModel('catalog/setup', 'catalog_setup');
            $setup->addAttribute(
                Mage_Catalog_Model_Product::ENTITY,
                Crossroads_Retain24_Helper_Data::VOUCHER_DISTRIBUTION,
                array(
                    'label' => 'Distribution method',
                    'group' => '',
                    'sort_order' => 10,
                    'backend' => '',
                    'type' => 'int',
                    'frontend' => '',
                    'note' => '',
                    'default' => '',
                    'wysiwyg_enabled' => false,
                    'input' => 'select',
                    'input_renderer' => '',
                    'source' => 'Crossroads_Retain24/Product_Attribute_Distribution',
                    'required' => false,
                    'user_defined' => false,
                    'unique' => false,
                    'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
                    'visible' => true,
                    'visible_on_front' => true,
                    'used_in_product_listing' => false,
                    'searchable' => false,
                    'visible_in_advanced_search' => false,
                    'filterable' => false,
                    'filterable_in_search' => false,
                    'comparable' => false,
                    'is_html_allowed_on_front' => false,
                    'apply_to' => 'virtual',
                    'is_configurable' => false,
                    'used_for_sort_by' => false,
                    'position' => 0,
                    'used_for_promo_rules' => false,
                )
            );
        }
        if (false) {
            $storeId = 2; // tui_sek
            $productId = 13031;
            Mage::app()->setCurrentStore($storeId);
            $product = Mage::getModel('catalog/product')->setStoreId($storeId)->load($productId);
            $distribution = $product->getAttributeText(Crossroads_Retain24_Helper_Data::VOUCHER_DISTRIBUTION);
            echo "<p>distribution text: {$distribution}</p>";
            $raw2 = $product->getData(Crossroads_Retain24_Helper_Data::VOUCHER_DISTRIBUTION);
            echo "<p>distribution value(2): {$raw2}</p>";
        }
        if (false) {
            Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);

            $distributionAttribute = Mage::getModel('eav/entity_attribute')->loadByCode('catalog_product', Crossroads_Retain24_Helper_Data::VOUCHER_DISTRIBUTION);
            $distributionAttributeId = $distributionAttribute->getId();
            $attributeSetup = new Mage_Eav_Model_Entity_Setup('core_setup');
            $attributeSetup->addAttributeOption([
                'attribute_id' => $distributionAttributeId,
                'values' => [
                    1 => "[1] SMS",
                    2 => "[2] E-Mail",
                    4 => "[4] External distribution",
                    5 => "[5] Snail-Mail",
                    6 => "[6] Own printout"
                ]
            ]);
        }
    }

    // Run by: /_auc/retain24/test_templatelist/
    public function test_templatelistAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::templatelistAction()");

        if (true) {
            $crt = Mage::helper("retain24")->getCrtFile();
            $key = Mage::helper("retain24")->getKeyFile();
            $url = Crossroads_Retain24_Helper_Data::BASE_URL_TEST . Crossroads_Retain24_Helper_Data::TEMPLATELIST;
            echo "<p>crt: {$crt}</p>\n";
            echo "<p>key: {$key}</p>";
            echo "<p>url: {$url}</p>";
        }

        if (true) {
            $helper = Mage::Helper('Retain24');
            $storeId = 2; // tui_sek
            Mage::app()->setCurrentStore($storeId);
            $store = Mage::app()->getStore();
            $xmlData = $helper->templatelist($store);
            $receipt = json_decode(json_encode($xmlData), true);
            echo '<pre>' . print_r($receipt, true) . '</pre>';
        }
    }

    // Run by: /_auc/retain24/test_purchase/
    public function test_purchaseAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::purchaseAction()");

        $fetchTemplate = false;

        if (false) {
            $storeId = 2; // tui_sek
            Mage::app()->setCurrentStore($storeId);

            $xml = new SimpleXMLElement('<?xml version="1.0" encoding="ISO-8859-1"?><TICKETANYWHERE></TICKETANYWHERE>');
            $xml->addChild('COUPON');
            $xml->COUPON->addAttribute('VER', '1.0');

            if ($fetchTemplate) {
                $xml->COUPON->addChild("TEMPLATELIST");
            } else {
                $xml->COUPON->addChild("SEND");
                $xml->COUPON->SEND->addChild("TEMPLATE", "000001061");
                $xml->COUPON->SEND->addChild("QTY", 333);
            }
            $xml->COUPON->SEND->addChild("MSISDN", "0046705353639");
            $xml->COUPON->SEND->addChild("EMAIL_ADDRESS", "jolo@crossroads.se");
            /*
            $xml->COUPON->SEND->addChild("SMS_TEXT", "Test");
            $xml->COUPON->SEND->addChild("EMAIL_TEXT", "Test");
            $xml->COUPON->SEND->addChild("SEND_DATE", "2019-05-08");
            $xml->COUPON->SEND->addChild("POSTADDRESS");
            $xml->COUPON->SEND->POSTADDRESS->addChild("DATA");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("RECEIVE_DATE", "2019-05-08");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("FIRSTNAME", "Test");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("LASTNAME", "Crossroads");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("ADDRESS", "Gamlestadsv. 2");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("ADDRESS2", "Hus B:19");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("ZIPCODE", "41511");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("CITY", "Gothenburg");
            $xml->COUPON->SEND->POSTADDRESS->DATA->addChild("COUNTRY", "SWEDEN");
            */

            $requestXML = htmlentities($xml->asXML(), ENT_QUOTES);
            echo "<p>{$requestXML}</p>";
            $requestArray = json_decode(json_encode($xml), true);
            echo "<pre>Request:\n" . print_r($requestArray, true) . '</pre>';

            if ($fetchTemplate) {
                $url = Crossroads_Retain24_Helper_Data::BASE_URL_TEST.rawurlencode(Crossroads_Retain24_Helper_Data::TEMPLATELIST);
            } else {
                $url = Crossroads_Retain24_Helper_Data::BASE_URL_TEST.rawurlencode(Crossroads_Retain24_Helper_Data::SEND);
            }

            $printableURL = htmlentities($url, ENT_QUOTES);
            echo "<p>{$printableURL}</p>";

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_VERBOSE, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSLCERT, Crossroads_Retain24_Helper_Data::CRT_FILE);
            curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'PEM');
            curl_setopt($ch, CURLOPT_SSLKEY, Crossroads_Retain24_Helper_Data::KEY_FILE);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xml->asXML());
            $result = curl_exec($ch);
            //Mage::log($result, LOG_DEBUG, "retain24-debug.log", true);
            $printableResult = htmlentities($result, ENT_QUOTES);
            echo "<p>Result: {$printableResult}</p>";

            if(curl_errno($ch)) {
                throw new Exception(sprintf("%s: Curl Error (%d) %s", __METHOD__, curl_errno($ch), curl_error($ch)));
            }
            if (!empty($result)) {
                $receipt = json_decode(json_encode(simplexml_load_string($result)), true);
                echo "<pre>Receipt:\n" . print_r($receipt, true) . '</pre>';
            } else {
                echo "<p>Result was empty</p>";
            }
        }
    }

    // Run by: /_auc/retain24/test_validate/
    public function test_validateAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::validateAction()");

        $fetchByPhone = true;

        if (false) {
            $storeId = 2; // tui_sek
            Mage::app()->setCurrentStore($storeId);

            $xml = new SimpleXMLElement('<?xml version="1.0" encoding="ISO-8859-1"?><TICKETANYWHERE></TICKETANYWHERE>');
            $xml->addChild('COUPON');
            $xml->COUPON->addAttribute('VER', '1.0');
            $xml->COUPON->addChild("VALIDATE");
            $xml->COUPON->VALIDATE->addAttribute('TYPE', 'STANDARD');
            if ($fetchByPhone) {
                $xml->COUPON->VALIDATE->addChild('MULTICODE', '0108858484015310');
                //$xml->COUPON->VALIDATE->addChild('MSISDN', '0046705353639');
                $xml->COUPON->VALIDATE->addChild('PIN', '01187');
            } else {
                $xml->COUPON->VALIDATE->addChild('MULTICODE', '0106543964903605');
                $xml->COUPON->VALIDATE->addChild('PIN', '52970');
            }

            $requestXML = htmlentities($xml->asXML(), ENT_QUOTES);
            echo "<p>{$requestXML}</p>";
            $requestArray = json_decode(json_encode($xml), true);
            echo "<pre>Request:\n" . print_r($requestArray, true) . '</pre>';

            $url = Crossroads_Retain24_Helper_Data::BASE_URL_TEST.rawurlencode(Crossroads_Retain24_Helper_Data::VALIDATE);

            $printableURL = htmlentities($url, ENT_QUOTES);
            echo "<p>{$printableURL}</p>";

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_VERBOSE, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSLCERT, Crossroads_Retain24_Helper_Data::CRT_FILE);
            curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'PEM');
            curl_setopt($ch, CURLOPT_SSLKEY, Crossroads_Retain24_Helper_Data::KEY_FILE);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xml->asXML());
            $result = curl_exec($ch);
            //Mage::log($result, LOG_DEBUG, "retain24-debug.log", true);
            $printableResult = htmlentities($result, ENT_QUOTES);
            echo "<p>Result: {$printableResult}</p>";

            if(curl_errno($ch)) {
                throw new Exception(sprintf("%s: Curl Error (%d) %s", __METHOD__, curl_errno($ch), curl_error($ch)));
            }
            if (!empty($result)) {
                $receipt = json_decode(json_encode(simplexml_load_string($result)), true);
                echo "<pre>Receipt:\n" . print_r($receipt, true) . '</pre>';
            } else {
                echo "<p>Result was empty</p>";
            }
        }
    }

    // Run by: /_auc/retain24/test_general/
    public function test_generalAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::generalAction()");

        if (false) {
            $orderId = 355065;
            $order = Mage::getModel('sales/order')->load($orderId);
            $itemList = Mage::helper('Retain24')->getVoucherItemList($order);
            echo '<pre>' . print_r($itemList, true) . '</pre>';
        }
        if (false) {
            $value = "22-12-12";
            if (preg_match('/^[0-9]{2,4}-[0-9]{2}-[0-9]{2}$/', $value)) {
                echo "<p>Match!</p>";
            } else {
                echo "<p>No match!</p>";
            }
        }
    }

    // Run by: /_auc/retain24/test_email/
    public function test_emailAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::emailAction()");

        $orderId = 355071;
        $order = Mage::getModel('sales/order')->load($orderId);
        $storeId = $order->getStoreId();

        $productId = 13035;
        $product = Mage::getModel('catalog/product')->setStoreId($storeId)->load($productId);

        $itemId = 394202;
        $codes = Mage::getModel("Crossroads_Retain24/voucher")->getCollection();
        $codes->addItemFilter($itemId);

        foreach($codes as $code) {
            echo '<pre>' . print_r($code->getData(), true) . '</pre>';
        }

        $mailTemplateId = 26;
        $emailTemplate = Mage::getModel('core/email_template')->load($mailTemplateId);
        $emailTemplate->setSenderName(Mage::getStoreConfig('trans_email/ident_sales/name', $storeId));
        $emailTemplate->setSenderEmail(Mage::getStoreConfig('trans_email/ident_sales/email', $storeId));

        $bcc = $product->getRetain24EmailBcc();
        if (!empty($bcc)) {
            $emails = array_filter(array_map('trim', explode(',', $bcc)));
            $emailTemplate->addBcc($emails);
        }

        $emailTemplateVariables = [
            'order' => $order,
            'product' => $product,
            'codes' => $codes
        ];

        $processedTemplate = $emailTemplate->getProcessedTemplate($emailTemplateVariables);

        echo '<p>' . htmlentities($processedTemplate) . '</p>';

        foreach($codes as $code) {
            $code->setData('sent_at', date('Y-m-d H:i:s'))->save();
        }

        // Add comment on order about sending of code(s)
        Mage::register('retain24_sent_by', "");
        $codeQty = count($codes);
        $codeWord = $codeQty > 1 ? "codes" : "code";
        $sentBy = Mage::registry('retain24_sent_by') ?? "system";
        $comment = "User '{$sentBy}' successfully sent {$codeQty} {$codeWord} for [{$product->getSku()}] {$product->getName()}";
        $history = $order->addStatusHistoryComment($comment);
        $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
        $order->save();

    }

    // Run by: /_auc/retain24/test_report/
    public function test_reportAction()
    {
        http_response_code(200);
        Mage::helper('integration')->checkIP();
        die("Crossroads_Retain24_Retain24_TestController::reportAction()");

        $helper = Mage::Helper('Retain24');
        $report = $helper->transaction_report(2, 1);
        echo '<pre>' . print_r($report, true) . '</pre>';
    }

}
