<?php

class Crossroads_Retain24_Model_Sales_Order_Total_Invoice_Retain24 extends Mage_Sales_Model_Order_Invoice_Total_Abstract
{
    public function collect(Mage_Sales_Model_Order_Invoice $invoice)
    {
        $order = $invoice->getOrder();

        // Refund the difference between already refunded and invoiced
        $amount     = $order->getRetain24Amount() - $order->getRetain24AmountInvoiced();
        $baseAmount = $order->getBaseRetain24Amount() - $order->getRetain24AmountInvoiced();

        $invoice->setGrandTotal($invoice->getGrandTotal() + $amount);
        $invoice->setBaseGrandTotal($invoice->getBaseGrandTotal() + $baseAmount);

        // Make sure we also add the specific amounts
        $invoice->setRetain24Amount($amount);
        $invoice->setBaseRetain24Amount($baseAmount);
        $invoice->setRetain24Code($order->getRetain24Code());

        return $this;
    }
}