<?php

$installer = $this;

$installer->startSetup();
$conn = $installer->getConnection();

$validation_table = $installer->getTable('Crossroads_Retain24/validation');
$order_table = $installer->getTable('sales/order');

$conn->addColumn($validation_table, 'order_id', [
    'type'      => Varien_Db_Ddl_Table::TYPE_INTEGER,
    'unsigned'  => true,
    'nullable'  => true,
    'default'   => null,
    'comment'   => 'Retain24 order id',
]);
$conn->dropForeignKey($validation_table, $installer->getFkName(
    'Crossroads_Retain24/validation',
    'quote_id',
    'sales/quote',
    'entity_id'
));

// Backport order id:s into existing rows (where possible)
$sql = "UPDATE {$validation_table} v INNER JOIN {$order_table} o ON(o.quote_id=v.quote_id) SET v.order_id = o.entity_id";
$conn->query($sql);

$installer->endSetup();
