<?php

$installer = $this;
$setup = Mage::getResourceModel('catalog/setup', 'catalog_setup');
$entityTypeId = (int) Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();

$installer->startSetup();
$conn = $installer->getConnection();

$attributesToProcess = [
    'serial_code_image_type' => [
        'sort_order' => 101
    ],
    'serial_code_image_params' => [
        'sort_order' => 102
    ]
];
$attributeSetName = 'Retain24';
$attributeGroupName = 'Retain24';
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);

if (!empty($attributeSetId)) {
    foreach ($attributesToProcess as $attributeName => $attributeData) {
        $attributeIt = $setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName);
        if (!empty($attributeIt)) {
            // Add new attribute to attribute set using attribute group
            $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeData['sort_order']);
        }
    }
} else {
    Mage::log("Attributeset with name '{$attributeSetName}' does not exists.", LOG_ERR);
}

$installer->endSetup();
