<?php

class Crossroads_Retain24_Model_Sales_Quote_Address_Total_Retain24 extends Mage_Sales_Model_Quote_Address_Total_Abstract {
    protected $_code = "retain24";

    public function collect(Mage_Sales_Model_Quote_Address $address) {
        parent::collect($address);

        if( ! count($this->_getAddressItems($address))) {
            return $this;
        }

        $quote = $address->getQuote();
        $model = Mage::getModel("Crossroads_Retain24/validation")->load($quote->getEntityId());

        if (!$model->getValidationId()) {
            return;
        }

        $totalValue = $model->getValue() * $model->getQty();
        $store      = $address->getQuote()->getStore();
        $orderTotal = $this->getOrderTotal($address);
        $baseAmount = - min($totalValue, $orderTotal);

        $amount = $store->convertPrice($baseAmount, false);

        if(abs($amount) < 0.01 || abs($baseAmount) < 0.01) {
            Mage::log(sprintf("%s: Amount or base amount is zero: %s", __METHOD__, json_encode([
                "amount"     => $amount,
                "baseAmount" => $baseAmount,
                "orderTotal" => $orderTotal,
                "totalValue" => $totalValue,
                "retain24"   => [
                    "code"         => $model->getCode(),
                    "value"        => $model->getValue(),
                    "qty"          => $model->getQty(),
                    "validationId" => $model->getValidationId(),
                ],
            ])), Zend_Log::ERR);
        }

        $address->setTotalAmount($this->getCode(), $amount);
        $address->setBaseTotalAmount($this->getCode(), $baseAmount);
        $address->setRetain24Code($model->getCode());
        $address->setRetain24Pin($model->getPin());

        $quote->setRetain24Code($model->getCode());
        $quote->setRetain24Pin($model->getPin());
    }

    public function fetch(Mage_Sales_Model_Quote_Address $address) {
        $address->addTotal([
            "code"           => $this->getCode(),
            "value"          => $address->getRetain24Amount(),
            "value_incl_tax" => $address->getRetain24Amount(),
            "value_excl_tax" => $address->getRetain24Amount(),
        ]);

        return $this;
    }

    public function getOrderTotal($address)
    {
        $quote      = $address->getQuote();
        $store      = $quote->getStore();
        $baseTotals = 0;

        foreach ($quote->getAddressesCollection() as $a) {
            $baseTotals += array_sum($a->getAllBaseTotalAmounts());
        }

        return $store->roundPrice($baseTotals);
    }
}