<?php

$installer = $this;

$installer->startSetup();

$setup = Mage::getResourceModel('catalog/setup', 'catalog_setup');
$entityTypeId = (int) Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();

// No migration of previous attributes necessary since all products have default values

$attributeSetName = 'Retain24';
$attributeGroupName = 'Retain24';
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);

$newAttributes = [
  Crossroads_Serialcodes_Helper_Data::VOUCHER_CODE_DELIMITER => ['sort_order' => 18],
  Crossroads_Serialcodes_Helper_Data::VOUCHER_CODE_GROUP => ['sort_order' => 19],
];

if (!empty($attributeSetId)) {
    // Add attributes to attribute set
    foreach ($newAttributes as $attributeName => $attributeData) {

        // Check if attribute exists
        if ($setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

            // Add attribute to attribute set using new attribute group
            $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeData['sort_order']);
        }
    }
} else {
    Mage::log("Attributeset with name '{$attributeSetName}' does not exists.", LOG_ERR);
}

// Remove attributes
$setup->removeAttribute('catalog_product', 'retain24_code_delimiter'); 
$setup->removeAttribute('catalog_product', 'retain24_code_group');

$installer->endSetup();
