<?php

declare(strict_types=1);

use MageQL\ClientException;
use GraphQL\Error\ClientAware;

class Crossroads_Retain24_ReCaptchaException
    extends ClientException
    implements ClientAware {
    public function __construct() {
        parent::__construct("ReCaptcha validation failed");
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "retain24";
    }

    public function getExtensions(): array {
        return [
            "code" => "retain24_recaptcha_verification_failed",
        ];
    }
}
