<?php

$installer = $this;

$conn = $installer->getConnection();

$retain24Type = [
    "type"      => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "nullable"  => false,
    "default"   => 0,
    "precision" => 10,
    "scale"     => 2,
];

$code = [
    "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
    "nullable" => true,
    "length"   => 255,
    "comment"  => "Retain24 code used for the order.",
];

$reservation_reference_id = [
    "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
    "nullable" => true,
    "length"   => 255,
    "comment"  => "Retain24 reservation reference id used for redemption.",
];

$validation_id = [
    "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
    "nullable" => true,
    "length"   => 255,
    "comment"  => "Retain24 code validation id used for reservation.",
];

$max_value = [
    "type"     => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "nullable"  => false,
    "default"   => 0,
    "precision" => 10,
    "scale"     => 2,
    "comment"  => "Retain24 code value.",
];

$conn->addColumn($this->getTable("sales/order"),         "base_retain24_amount", array_merge($retain24Type, ["comment" => "Retain24 discount amount in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"),         "base_retain24_amount_invoiced", array_merge($retain24Type, ["comment" => "Retain24 discount amount invoiced in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"),         "base_retain24_amount_refunded", array_merge($retain24Type, ["comment" => "Retain24 discount amount refunded in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"),         "retain24_amount",      array_merge($retain24Type, ["comment" => "Retain24 discount amount, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"),         "retain24_amount_invoiced",      array_merge($retain24Type, ["comment" => "Retain24 discount amount invoiced, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"),         "retain24_amount_refunded",      array_merge($retain24Type, ["comment" => "Retain24 discount amount refunded, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"),         "retain24_code", $code);
$conn->addColumn($this->getTable("sales/order"),         "retain24_reservation_reference_id", $reservation_reference_id);

$conn->addColumn($this->getTable("sales/quote_address"), "base_retain24_amount", array_merge($retain24Type, ["comment" => "Retain24 discount amount in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/quote_address"), "retain24_amount",      array_merge($retain24Type, ["comment" => "Retain24 discount amount, not part of tax total"]));
$conn->addColumn($this->getTable("sales/quote_address"), "retain24_code", $code);

$conn->addColumn($this->getTable("sales/invoice"),       "base_retain24_amount", array_merge($retain24Type, ["comment" => "Retain24 discount amount in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/invoice"),       "retain24_amount",      array_merge($retain24Type, ["comment" => "Retain24 discount amount, not part of tax total"]));
$conn->addColumn($this->getTable("sales/invoice"),       "retain24_code", $code);

$conn->addColumn($this->getTable("sales/creditmemo"),    "base_retain24_amount", array_merge($retain24Type, ["comment" => "Retain24 discount amount in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/creditmemo"),    "retain24_amount",      array_merge($retain24Type, ["comment" => "Retain24 discount amount, not part of tax total"]));
$conn->addColumn($this->getTable("sales/creditmemo"),    "retain24_code", $code);

$table = $conn->newTable($installer->getTable("Crossroads_Retain24/validation"))
    ->addColumn("quote_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity"       => true,
        "unsigned"       => true,
        "nullable"       => false,
        "primary"        => true,
    ], "Retain24 quote id")
    ->addColumn("validation_id", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable"       => false,
    ], "Retain24 validation id")
    ->addColumn("code", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable"       => false,
    ], "Retain24 code")
    ->addColumn("name", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable"       => false,
    ], "Retain24 name")
    ->addColumn("qty", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned"       => true,
        "nullable"       => false,
    ], "Retain24 qty")
    ->addColumn("value", Varien_Db_Ddl_Table::TYPE_DECIMAL, null, [
        "nullable"       => false,
        "precision"      => 10,
        "scale"          => 2,
    ], "Retain24 value")
    ->addColumn("currency", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable"       => false,
    ], "Retain24 currency")
    ->addColumn("pin", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned"       => true,
        "nullable"       => true,
    ], "Retain24 pin")
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "Crossroads_Retain24/validation",
            "quote_id",
            "sales/quote",
            "entity_id"
        ),
        "quote_id", $installer->getTable("sales/quote"), "entity_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");
$conn->createTable($table);

$table = $conn->newTable($installer->getTable("Crossroads_Retain24/reservation"))
    ->addColumn("quote_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity"       => true,
        "unsigned"       => true,
        "nullable"       => false,
        "primary"        => true,
    ], "Retain24 quote id")
    ->addColumn("reference_id", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable"       => false,
    ], "Retain24 reservation reference id")
    ->addColumn("expiry_date", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, 255, [
        "nullable"       => false,
    ], "Retain24 reservation expiry date")
    ->addColumn("reserved_qty", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned"       => true,
        "nullable"       => false,
    ], "Retain24 reserved qty")
    ->addColumn("validation_id", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable"       => false,
    ], "Retain24 validation id")
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("status", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned"       => true,
        "nullable"       => true,
    ], "Retain24 status. 1 = Reserved, 2 = Redeemed, 3 = Canceled, 99 = Error")
    ->addColumn("status_message", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable"       => false,
    ], "Retain24 status message")
    ->addForeignKey(
        $installer->getFkName(
            "Crossroads_Retain24/reservation",
            "quote_id",
            "sales/quote",
            "entity_id"
        ),
        "quote_id", $installer->getTable("sales/quote"), "entity_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");
$conn->createTable($table);

$installer->endSetup();