<?php

class Crossroads_Retain24_Helper_Image extends Mage_Core_Helper_Abstract
{
    public function getImage($params)
    {
        $image = null;
        if (!empty($params['hash'])) {
            $hash = rtrim($params['hash'], '.png');
            $image = Mage::getModel("Crossroads_Retain24/Voucher_Image")->loadByHash($hash);
            if (!empty($image)) {
                http_response_code(200);
                header('Content-type: image/png');
                header("Content-Length: " . strlen($image->getImageData()));
                header("Content-Disposition: filename={$params['hash']}");
                echo $image->getImageData();
                exit;
            }
        }

        $defaultFile = base64_decode(
            'iVBORw0KGgoAAAANSUhEUgAAATgAAABTCAIAAACEWYwQAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJ
            bWFnZVJlYWR5ccllPAAAAyhpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdp
            bj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6
            eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTM4IDc5LjE1
            OTgyNCwgMjAxNi8wOS8xNC0wMTowOTowMSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJo
            dHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlw
            dGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEu
            MC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVz
            b3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1N
            OkRvY3VtZW50SUQ9InhtcC5kaWQ6RkU2MEUwRkFEMEVDMTFFNjhGNTZEQkZGNTQwODFCQ0MiIHht
            cE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RkU2MEUwRjlEMEVDMTFFNjhGNTZEQkZGNTQwODFCQ0Mi
            IHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTcgKE1hY2ludG9zaCkiPiA8
            eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpGNzJEQ0E4N0QwM0Ix
            MUU2QUJBN0IwOTRDQjUzQTZENiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpGNzJEQ0E4OEQw
            M0IxMUU2QUJBN0IwOTRDQjUzQTZENiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8
            L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pp5BtHoAAB5oSURBVHja7F1XkFVF87/A9yBJ
            q2QJCgbYJSlBEP6CIsFlSQoG3IUFVIJksSyCgoQHkqICkkFdBMmplCB5lyB5FZAFyaBQKNGyQMAX
            5P+r7bKrnZkz99wEe79v+uHWuefMmenp6TjTZybf7du3Aw4cOMjbkN+RwIEDJ6gOHDhwgurAgRNU
            Bw4cOEF14MCBE1QHDpygOnDgwAlq9CHqy8VUofx1NLnD9TtBzdOM5Wf4uSQXzpcvX3SRoQrxiyai
            XvkdEBhCWz6KrlwxWbxav4uSHI8aJF+8IG2UB/8378DA501xZYG0ECpGFPMzOnlfzTmLGo4FU9QK
            2wT5e+cHPl8u5H3qESxZsqRixYq4k5KSsnPnTikq0dXaVO327duTk5NxjUbRtNJW7Oim9yV27oOz
            qDbzRRx26tSpTZs27d+/f/369ceOHcOjChUqNGnS5IknnqhUqRJ+CxcuHCNMMjIy9u7du3HjRmo3
            z1JSiuLp06fLlSvHj0Cro0ePxrRpjALowyr15MmTZcuWjbVeU7RPTk5O9erVGYdFixalpaXFF9v/
            J/6c9X8GACI6ZMiQhQsXKgb2+PHjJDn4u2/fPoxQjFwsVD5t2jQ92MvL5vTvv/++8163l3MUO3GV
            3n6M/AXn+vqCdevWJSUlSSmVDjCzwr333mvxnKNl3vM4B0j0EhMT4QiUL18e188999yECRNix8RE
            80mTJjVq1Aj1w3p/8cUXbM9jLT8WLRCPovufeJRS2NJmzZr5YU14WT4HLyozJXnfogI6derUuXNn
            /2wdISAMadq0aXgSdYcp4wQ1yvZh8ODBciaJYq02bdpUrVoVd/Lnz//jjz+eOHECrqnRFO/YsePK
            lStTpkxBDbAtKSkpUPN16tR5+umnjS1evHhx5cqVCIMnT54MK/RMLoD5grqRiMe2bNmCOHbDhg3w
            xtu2bQs8q1Sp0rx58yJFivjpLM2+bN68uUGDBqmpqdevX1+9evXWrVsRkNesWbNYsWItW7ZkMThw
            4AAaQhSKrqWnp9eqVQtdA02UOvv06YNflMHvW2+9BYsn9Q51FqQ7fPhwVlYWBfzQd48//ni9evUo
            4KfCekmiJJUsVKgQVThz5kyUIQooRgy9w+/BgwdBE/Tu0qVLK1asoMI1atRAhURnI2VAijVr1mza
            tCkzM5PCbEIAhGrRogUYYNeuXdnZ2QsWLNBd4rj0IW/HG0DMFF04duzYa9eucQHID13ImwCIDcTM
            QorevXtfuHBBvoKq1q5dayz8XC54UfLPP/8EVorC5r8VK1aE2AftKVrnV8CF4Ev86qagV69e4Fp4
            lca2gIYki6wTF3hXtsiVGE3N4sWLmbaff/65xRyhJNcJqnpRSc5p4RVjVdBuIKZCGQwlaKjjqaOE
            4VPaAoCFJJ/EBcSToBJlP/nkEzkkkBZZgKmvDAOGVudyfVxRmxRv2Ci59GIPe2SLsFT2V3AfWj/4
            8Phz2BAEWgpA/CRNZDFIET9CMb1meYfFT1EKlpIsqDIslL3z43xKJPELZcpDaWxdKsTt27frvfaj
            JZ2gRiqrbMdoPKSat7wFxawMLZxD2BPFKqJONkEApS07Y/FbZBxkyeTkZHCboimkirEIqmWR1kuu
            dDsjPQVZEgqF6AM/VnkFOIM+oBtCCbpJmgVVKU2gI+idpDAUHOtNPxY1qLhC3lhQYczlK8BzcS7I
            hvAUygva2agUWEXGkVGNP9dX4SceDIXo8i+GWUoaolnwJRfAsCkaGp4k7m/btk3eJOeT3DD4TswW
            iq0gVSJdVnAtu53SwUMZ4j//nR06dCj6i3pOnTqFXijCiaeIzKm/UENKrGusk11fxcNnj5EwR6PA
            nEiNIF8vycQEAlzSj0WVj1CSRAiVoC+yFbhR/JbsGsgrPSApqxBgL6Xgx5dxghoRgAN0O+alF/l+
            RkaGrp712Iw5nvwlmurQeZdBsdLUHJhM2gfItkQP1+wVywAyqKCSfpGhJpFCagTSL1QAvMjdAcAK
            Getkr1IJEZWwVuKvl+QCt27d0ocDTUg7b4zAKRZV+i61p3xq9IqVXpAX4KUU4tGixtk6Kgyalwdo
            XFinm3v37pX39dnd2rVry2zEc+fO0VyrrEqffixWrJhkQfpFWxKT+vXrK+ET7shpYZ9LCKizePHi
            si1akGSnLiUlpVChQlygWrVqnG9AcquvHFqSB8eNGwexV5KEjStS0DU3b96kpxAPY53GzAelchBT
            yQZFj7jkwoULvcZXaYWVpoIGib2Og0t4iNXCvTEM8yI63dywYYPUzfpya1JSkhzCnJwc/F65ckW6
            iMZ12qAJDyQ8Emi6kmDq1Kn+0xUsrSiP9FeMXxHRBBg9bdiwoayhX79+RYoUGTZsGEgHiZXvNmjQ
            QFYyYMCAwoULo+T69euhRo2TOpZeSMR0raePO40gK68jR46wCsDFmTNn5AQbiTEVZrGn4Y671Zl4
            ElRpOY0p13STlze5DK3gsebWOUmKE27+/vvvuFDSnnR2N6qGLVu2KDgrQCmNeWEdXybZlShRQp/L
            HTFiBPyIGjVqkIGlmyhJ0zmSJijZrFmzWrVqwcDeuHEjDNz8L2/C/eHCWVlZiGYPHjx44MABhCrQ
            L1ysRYsWXvNwuvZ0ghplAJdYpkDJRJADZlzdNn51Zb+jOH7yqTHhwS4kXgbn7jopbKkgZnoZRN0Q
            gDfffBMSSOXT09P1kujO0aNHYWC7dOnCUh15TxUPFr8dOnSQ4evIkSPh50P9KXn2r7/+ulH44/Sr
            urgRVCJ6qVKlZCiCC6jSf/Xn32GS17fRMiuY5C2opjcGbMqyjf1TdemkBe52oqnuFMCD7du3L6JZ
            OePKOMO/+PDDD6l8wYIF9ZJMUpQcM2aMTu3wJETJrSfjT/N8XmtmCC7WrVuXkJBgjK7jdFOOePoe
            lYhLy48kJLjgr7S8JAR/pQK+fPmySoL8+WnRhe/cf//91JBx5kOaa30fAw7h5C4TyhyjnGy8i4pP
            wZwuYJ2GDx8OgoDXaU6VSQr/liaW6W/VqlWp5Nq1a+VUNp5SSWUgwuusrmpPnToF40n3IZPEDySf
            QHjx4sVbt25t0qSJ4rwoKjLucgnjL0Z9/vnnpe2aPn26rrCVMaCJBCqwaNEi3Z5g7GUrlDNcuXJl
            vrl+/Xr94yxWFrpd5Rcp4THPKj7d5hDysK7g9cmTJ9OqKT8FoRQ6oCTi2IkTJ/L6Kj3yM6EdHtrd
            unVj7Txz5szMzExihiNHjgDh1NRUmFzdzpMLsG/fPrlwFUfMH39J+XXq1JF/s7Kyxo8f3717d/mB
            OI3BhQsXKKatUaMG8yWlK/AKDd3Mzs6W7Fu6dGl6i28eO3YMPKp/8axr5SeffFKq8EmTJsFG+UzB
            v/MWVf9V5BDi6hWiK/IjV1OiaKyUqi5evAjJlOQ9d+4cPSpTpgzxQGJiIjODspoVxxB3KYQys48B
            zu2wYcMW/wNjx46lMpyZFPj3/D6l1FFtiHLJN+YC5AnTW3KuRWaH60nkeuIhQXp6OpxDvCtzofA6
            AryQ0rCUxf2wnyr3GSugDaxkzhZAyfqgXlBJTkuk8krcyLSSXnHAI4XQiL8xpQnVckqjZZYOGMLC
            yygDowyuIN/4dhxCIB6R3r9/v081xMyky3abNm3AQ/p9mS2kJ39jpPGWMSlcZiz6XJmQqXZ3WFAJ
            GZnvzoXLly/fOxcU4nB6kNSPsiSbL5lIxJlJ4QlqQEtpMn4SYAQeSiWTmWTVfT1zJ8Dr6zNFHjhZ
            TAmZvOITcJ40m7rIWbLz5cAb1zn06dagSafyReWTtJAEVb5rfItTlyxAqZdUUgnUjSUJ9FwROyZM
            Rq9sfgyQrii9gCis9E6nlUshjJW73rRpU3CD/nWLMt/D07kIUeD8sOI3LpbCDqxevRrhDT+tW7cu
            ffylT7okJSUp3q/EoW/fvnjKSUg6etTEkSNH/C8k+k9j0Mvz2rJXVTKKJt9SmXGBZqTAnkrKuWKF
            mFwyVPyV1W8vhMeMGcN7YoHIEEK0SCFPRkYGZ57RK8at22hWP74gLrdioTEAN2RmZu7YsYO+5V+0
            aBENbXJycqVKlRrkQokSJXi8q1SpsnLlyu+++w4Sfvz4cU48gitbtmxZ2uFB4RVcdOnSpXbt2hs3
            bkQTeIWS4xs3btyqVauEhASwBdWjTzKlpqY2b958zZo1OTk5aDErK4sdSDBKw4YNa9asmZiY6FPw
            /M/QGHfx5dxX477bNNeCMGHz5s0HDx6EGNDcOO+ZAGwp05hUHkpu2bIF/WIyUsn69eujJNE8jDlV
            ZUJLxqKMMJzYESNGUOG0tDQQmRaKuHedO3cGMsOHD5c4VKtWDQq3a9euZOGVsDk+eP72f925A/qq
            g32naeNTfd9qpZjXxtZ6bZby/hnaso+2UaqDdtD/I5/YRnETKQut4BbJHMzr168XLFhQKZyens5a
            GGaWhDkQ55t9x/dO+UHFJnIhDwM3n5VEiG1IUhfT1Z1o4U/pn0FfREDBrm/58uV79OhRpkwZenT2
            7NlVq1bBL2CuPn/+fMmSJaOCsBPUOyHeIY2QnsUSknB6WXKLlQ5bcUQurhZUQxLR8FSSH2yVR0uW
            LAm6fTZhCHcXkcud1F+xg3idTDLe1D+hUnLH/NSjzGTat0Hx+ohHmYkxfrrlU0pv/3uzYom5XVos
            qVpBY1ojlYxd0/1tZSrImCmh42/Jf1ZwgyvLn+8YNzcjSwunl3ZFzVMp1v9DFjVU2+hlKHyayvCM
            dnh2ODxbFKEv7T/6jW6AGmFQcPHiRXi5vBUrT9RBRKtWrUrziLGLop2gOnDg4L/F9XXgwAmqAwcO
            nKA6cODACaoDB05QHThw4ATVgQMHTlAdOHCCGgJ4bcEc9ObdBeNuhv57dBf75b9RZa/6sKu17PwY
            O8r4HIWoN3Rn3s0fSWOWTXG9HilpcQGPvXbDSHMx3gybOSwHZCiHpujY2k9njB0DedHfvmeqjnnQ
            vb8sA6cTxGcGnyXH0+dZAUFTvnzuWhpUI4eX/hWILDUqHEH12jWX7mRnZz/22GOWEwH1fFH7NtnG
            cTIeZKI84l0Cg4qN8UtlL1nVP8L2I/CW/X7tX5z6kTG9covu8HmEpJEsylapxtbtp4343ynfqAH1
            dvVMY2NypX8Bs+tZurhx48ZHH320Z88eP6bbmCAdc0GtUqXK4wJSUlLef//9n376iQtcvXrVqDv9
            7ExtV4FeGeoB748wvMbMSEG7YZQ8qnSQ/o4ZM4ZGzti6n+GXAFZITk5WDFGon8XYvQzjLg108fHH
            H6MvUrcGTFulKvhbNKlP8TDu6qBQQCGCPmpemiIMl96LztevX589e/b58+ctdkXnTJ9RgBFC3uEB
            bfTp06d+/fpkWyCWy5cvT0tLW7RoEeSWbgZlTZ++rp4srhzgp/OKUUqNJUP9iNzYlsxo37dvX+3a
            tSPRoLK/P//8M/GB0SgpeAalnvFMZKPY01t79+6tVauWvSNhVB65NTO25bMVP5/v+fSNixcvfujQ
            Ia9K5KDo6iY8uxrOViwPPvggnFtu9amnnjp16tS8efNGjx5ttI1yY3sjsSzfN1pkST6S3xx7fWXm
            VbNF4O2Yy4ZwzXvwh/0RufFbNjvP2SN8//ZcaZr6YrRdRvp77YMR3pf3ljJe/bXQWRceS81+Pvq1
            +G5+WCWotYhhjNqyZUv2+vTvD2/evAmHvnHjxnCbe/XqdfjwYfkUmglP4ULDIMPZwzUdRkSt4HrG
            jBl4l55KNxtlUBUqhNZo1qwZPM9Lly4FrCdB4d1BgwY1adIEFfbu3XvFihWMLdAYPHgwNYRfoIHa
            uCo0NH36dPwCASqAv3/99Rfv1o+u/fbbb/A1KCIgTC5evPjZZ5+1bduWbrZr127lypUSJRRD71AA
            r+MXDickBI/w99VXX4XqQddwjUa9IgLUgNapCfyCCHRaZHZ2Nu4odEBtvNU4YO7cudQ0CDtkyBAy
            EdOmTatateqvv/6KvlCYwwqISEQjBQqgLZZnIiD6QiTCU3SWyLtp0yYaI/zyxlEMGJGePXuiRVRL
            FcrBojNs4LIRnrt37zZyI+gM/FEDtYIW2csF/8yfPx+vowl0ExjKA6zQBAYaNVATeB0DhN4RjynH
            DqEASM3voo8y0kEZvIW+p+QCuAtVcQ0gC7pJoSIxaqjzUuFYVN2JL1q0KNg08M9ptnJeFJTq1KlT
            YmLihAkTyD9MTU1dsmQJ2WTA/v37S5cuDWtcuHBhEHHcuHH9+/eng0NR24ABA+677z48pc3vjh8/
            ToSmIwzAzSAN7VUFtktPTwdzFCpUyKgCQVZg8sYbb4waNQq1Xbhw4ejRo/QI7ItHYM327dsHcvcu
            nDVrFtcWyN0feOnSpcuWLUOZDh06wCmFBP7yyy8ffPBBIPfgsNatWzds2BB/69atizu0FdjPudCt
            W7dSpUrhL/o+cOBANN2oUSO0C8qgiQoVKlABNAqHE78JCQlgtZ07d0Kn0CGOeMVoJ401gD6o4dq1
            a3o0DkCoQnfAc5s3b8aLJUuWxP0TJ04QYUEfUFXvC6jXuXNn8B+6T3t2gkTgXbA4Bo6kZeLEiagT
            KKEMKsTfXbt2nTx5snv37hgjdB/UmzRpEu8dCc4GM0D4cR9/4ZShQvB3wYIFA7m7qOAV4HngwAHq
            4KOPPmq0dW+//Xa5cuU+/fRTXOMtOqYVj6BJ+/XrR6dgoJsg15dffgnaZmRkYFipMCgG3ZSTk9O1
            a1e4io888sjatWtXrVpVuXJlaTkhaShDioNuUkOMCZQI6ANOIF7FU+Yu6iYYlboJRiUtds8994Tg
            Boe6vygEDGOj7F+MtqGu6DozMxNl+BHpKlnDnDlzoF286gdn43X88jUdTKRDmzZtQGJ5B9Wicq+N
            lYGhLC+LKY+IEVE/+kV/YQqACXjRiCdThs9BUeqna/yC7YAk/SWi6b2jpwoZjUfZo7PQ60b6KK/T
            ixJDMCJ4yzLKXPLvXNBJhHYliahFSSI8UkiEGuTQyxEkDHv06KFUiPKyg0xJZSCMRADv6RRGhd98
            8w03ATooTVC7ylsQUWVfZWW4mT46htRNeQctcjdjvq+vDO6hBRGpGiMr6Cc61onh2Wefhd71Ou4W
            Ko0sWCD3wFkaCV25wHmAhmvevLm837RpUxgi4yQ+rB9sPpVXlkNQPz9igJWAP88bcFOFZFvoLcKT
            trr3uWRKW4TASBLpUDl0MPUxaLRm9JR27NgBAxj0WF597RpQvXp1nqwyLldKe3LmzBmQCPGFrBbt
            gkTbtm2TN3lXUcADDzzAhCKA8cfQ0zWNIOqUw4FRUI7VUjqox3j0lGINhVzgPZgyhT5gkvXr18sK
            O3bsKMvQ4UbwBeQM/OzZs1955RUvCkvuUgJUIAaPgE5V5vLotUK3mMSoCGB++ge+//57eGigOLwL
            elqgQAHJeceOHYNHoYgikFYoq9CanAq4cNBk8MQQvME7ZacXr58+fVphAuYDGdYz4ehsCyqvLMGT
            EcAjhVPBZ/C0vXb38VrC1VfPKEoHKHILiSWX2M8yo9fp5kxbrzVPydySLO+88w4GDv4YnAXCTR4k
            qRwbSyINz1PpApHIsvJhOUuaRhB1yuFISkqCayrL08l6ltU1qAZ0BMYA3grPX1Ar4D1oRgUl3FH2
            PUf0qygg+Kjy0B1of/RU7iquGCqyK8RCiqpFNxEMPvTQQ/JddHPr1q0hZbyEszyD2AORBg8VbOm3
            337LMnPr1i2JKE1LKGJDK1Esn+PHj6eJBwA0veQw6Oxq1aqtWbMGgwF2QaiDMACkRAxGJFYOKZUz
            b/ImxS3GdBlSCsrcID09d+6c14KQ1+yaskXTggULEBERo4NW4Co720Xi4Cgzn/rWm1I9YdQgEhs3
            bkSw3ScXiLCcfSVf58HSpythSbizxha9Nj2jEdRnvOTsPYlN0KlmOoMcDm1aWlr9+vXfffddimZp
            eo8Ly13IJSbSnNJN2EZwOFwtqmfZsmWwzAgpJZ5Sken0kSYHJVndEBp2QkVHUFHdhx9+CPnxtNH5
            88tJavyFYOtnMTF+dFITmIYnYF544QVZACqgRy5AXw4fPvzq1asYiaJFi+LpwYMHg7qIfIwn+TA8
            KlyG5kKM+3STvVKMqvE4VsV00NMZM2bA7cGQ08wZDBeGHN4HvQJzKgcsjB3VIPnGTC+ftZUoUSI9
            Pb1du3aSsLxLveyOPPBCWecAiZS8COMyhr4pKUYQvzy/qsuzThzLusv/5cLgwYOnTJkycOBA2oAb
            9IHL4MV7xhMD6D5YrkGDBohNIKgwJHDT3nvvPaVp4nNmIYW7JOlQTGfUkNZ4w3F92SnyAgqauWFE
            pHLhXomFzp49iz689tprHP6BNLJ+iTrYvW/fvogWcF2yZEkURuykzIp5JTmRk6mEu1SSHiHMULgB
            aMvjGJl39eU4nbnpAmIJNcTz2wULFixdujTjWbFixaNHj/rM5jEGkKgBXpzxsBZW+fY8RKqHCPvV
            V195NU17WINECn/DZLFvqRMfvpXX+iEu6OharlOPQhUD6BV0yJsQGBAcqpCWADF8vEGhPaDQlR0C
            rlmzZuE+AtpGjRpxZCQNI99hFtJHUJIupByySAU1qI1WYrl69eotX75cTh0ZUwIZV5S0109EAeHA
            9KtXr9Zzx4yvozzcj1WrVukdwSOoXgruZe/gjT/zzDNeiTi6OycXpbgkTR5yefL36GmzZs0gyTCz
            Rq1EmliXAVmmadOmqIEopoxLYmIiiwG9RdflypXzCrZ5R3l9BU6SSL64cuVKJpEULaqhQIEClkgb
            Ghl1IqixzJwZU4vtiYfkhSYkJOARKIxQ02va0ithmy7q1KmDqC07Oxt9bN26tSWLBhcPP/wwuAsl
            Jao86cjdtEfyUXZ9Q5Xbl19+GeLRv39/qCiSsRMnTsAOwMti+Rk1ahSMarFixWDxoMZotpD0EIq1
            b9+e2A4mbvTo0bSrMmDkyJFdunSBw9awYUOwNa0iwhNr1aqVEbehQ4cihvnjjz+AElQv0Ni1axcq
            xCP8durUCVIEhwfchsFGwHP58mU6b9u4KqtPQr700ktLly6lc58oYkeXx44d269fP/KggJ7UFI0b
            N543bx66A+czKSkJ+MPFgttPFrhs2bJod/78+XSSNzwO3ZNEDSig1ICopHLlykDgxRdfhMNGS4gX
            LlxALIo7vBTZtm1bEKp69eqoB08xBLxdNX5RUumLJBEtX3399ddEIi/fW/nMSOdR1NmxY0ceQZD9
            hx9+oBHU07y9mA1MQjOOxF1z584FhuSgKfQhLwk2FioeVPJK7SbywomFcR4/fjzsM4Q2qCwNGzYM
            cSy4C2yAvijcBRyM3QwhVAl7HdW4ZATYvXs3Jf3KBbdp06ZR5kdycjJC3EOHDvFTcDAIjfsg66BB
            gyCr+EUneSmsZ8+ej+UCxExpGvWgMN7FU1qtkqt2Om5cHoBq5TrYnj17ENugHnA5ngIlmg2mGtAp
            fVUTd+RSJMqjcsKEWwff4C+tB+IanZX1MGXQKOGvLOjhJpCRa25Kj6gGaoJq4PNd8YhbRxNz5syR
            lSukY8JSE3pfABgUuknjyCTyGncimkQYNShkpFwxQgPjO3XqVB5BI82NwExCWMlughogAp7iES2Z
            MpMAMR1nfUlfWellwIvKQrSFu+gRONyLUYNCmBtwR/08j0hyYkO1+eGdBBUIa996/1msofY3jDOs
            wvucMlonQYV6dk60wD/1otu0H5bwzyRhJjx4HRni8wNlPeQwrp14TX74+cjYQnqvbPJQQ3zL91Be
            qHp9seAV9+rjagmr/AyWn69eLVPolrUlC/4WUlu+bvNPfHuP7CtqlnySgI/tR+wfToQ6g2UbxBht
            DhKSyY31oSD+1XbYmPg/XzRoybBPoIv8VFg/lLEbyTAO19F5N5JDdKLiskU+3FE/+TacWd8wTK7P
            wrpKtm+nYvzYP+jcoOIKhqrOjW0ZF+WMZbyW7/xIaVD9bbTDQZM0LFZFsUvK/JDdWwlKTyUvJRDZ
            Hgg+FyMC3gfP+fdTgh4OaN87QSd40BPlw1lHDeND9ZAcS2V93Osb14D3F5J2D1P/8tvik3uNgd6W
            hYMtW+bon/8HfG8sZEnZM57RaHfnjOuxynBTEoIfHeqnXa94x+f5iBbt7IczWenYV2t91qZ/yx50
            M62QjoEM3/UNz4Xzf7xfjM7t9eMrRsWxD2O6IkL3KeDvXHb/RIuWu2u087GeKPLTNfvx0z4H0T9V
            g35xYcE5yjFqJPNa/llEZ7uAaYOSWASxIQU/QfkgunF75GLg50RjC4/6JGPkIaJ9BijCWNfeU/9N
            hCGuto043PmoDhzkfXA75Ttw4ATVgQMHTlAdOHCC6sCBAyeoDhw4cILqwIETVAcOHDhBdeDAgRNU
            Bw6coDpw4CD68P8CDACIM1/pCRUS2gAAAABJRU5ErkJggg=='
        );

        http_response_code(200);
        header('Content-type: image/png');
        header("Content-Length: " . strlen($defaultFile));
        header("Content-Disposition: filename={$params['hash']}");
        echo $defaultFile;
        exit;
    }

    public function recreateImage($params)
    {
        http_response_code(200);

        if (empty($params['id'])) {
            die("Missing data!");
        }

        $voucherId = intval($params['id']);
        if (empty($voucherId)) {
            die("Wrong data!");
        }

        $sqlQuery = "SELECT i.order_id, v.item_id, i.product_id, v.voucher_code FROM crossroads_retain24_voucher v JOIN sales_flat_order_item i ON i.item_id = v.item_id WHERE v.entity_id = ?";
        $data = Mage::getSingleton('core/resource')->getConnection("core_read")->fetchRow($sqlQuery, $voucherId);
        if (empty($data['order_id']) || empty($data['item_id']) || empty($data['product_id']) || empty($data['voucher_code'])) {
            die("Found no data!");
        }

        $order = Mage::getModel('sales/order')->load($data['order_id']);
        if (empty($order) || !$order->getId()) {
            die("Unable to load order!");
        }

        $helper = Mage::helper('Retain24');
        $itemList = $helper->getVoucherItemList($order);
        if (empty($itemList[$data['item_id']])) {
            die("Found no matching voucher item!");
        }

        $storeId = $order->getStoreId();
        $product = Mage::getModel('catalog/product')->setStoreId($storeId)->load($data['product_id']);
        $itemList[$data['item_id']]['product_config'] = $helper->getProductConfig($product);
        
        $helper->createCodeImage($voucherId, $itemList[$data['item_id']], ['MULTICODE' => $data['voucher_code']]);

        die("Ok");
    }
}