<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$conn->addColumn($this->getTable("Crossroads_Retain24/validation"), "code_type", [
    "type"     => Varien_Db_Ddl_Table::TYPE_SMALLINT,
    "nullable" => false,
    "comment"  => "Code type",
]);

$conn->addColumn($this->getTable("Crossroads_Retain24/validation"), "code_status", [
    "type"     => Varien_Db_Ddl_Table::TYPE_SMALLINT,
    "nullable" => false,
    "comment"  => "Code status",
]);

$conn->addColumn($this->getTable("Crossroads_Retain24/validation"), "requires_pin", [
    "type"     => Varien_Db_Ddl_Table::TYPE_BOOLEAN,
    "nullable" => false,
    "comment"  => "If the code requires pin",
]);

$conn->addColumn($this->getTable("Crossroads_Retain24/validation"), "qty_max", [
    "type"      => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "nullable"  => true,
    "default"   => 0,
    "precision" => 10,
    "scale"     => 2,
    "comment"  => "Maximum quantity which can be stored in the gift card",
]);

$conn->addColumn($this->getTable("Crossroads_Retain24/validation"), "description", [
    "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
    "nullable" => true,
    "comment"  => "Description of the code",
]);

$conn->addColumn($this->getTable("Crossroads_Retain24/validation"), "usage_end", [
    "type"     => Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
    "nullable" => true,
    "comment"  => "End date for the code",
]);

$installer->endSetup();
