<?php

$installer = $this;
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");
$entityTypeId = (int) Mage::getModel("catalog/product")->getResource()->getEntityType()->getId();

$installer->startSetup();
$conn = $installer->getConnection();

$newAttributes = [
    Crossroads_Retain24_Helper_Data::CODE_FORMAT => [
        "label" => "Code format",
        "group" => "",
        "sort_order" => 13,
        "backend" => "",
        "type" => "varchar",
        "frontend" => "",
        "note"=> "json encoded",
        "default" => "",
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => false,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ],
];

$attributeSetName = "Retain24";
$attributeGroupName = "Retain24";
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);
$existingAttributes = Mage::getModel("catalog/product_attribute_api")->items($attributeSetId);

// Add new attributes
foreach ($newAttributes as $attributeName => $attributeData) {

    // Check if attribute already exists
    if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

        // Add new attribute
        $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

    } else {
        Mage::log("Attribute '{$attributeName}' already exists.");
    }

    // Check if attribute already belongs to attribute set
    $isFound = false;
    foreach ($existingAttributes as $attribute) {
        if ($attribute->getAttributeCode() == $attributeName) {
            $isFound = true;
            break;
        }
    }
    if (!$isFound) {

        // Add new attribute to attribute set using attribute group
        $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeData["sort_order"]);

    } else {
        Mage::log("Attribute '{$attributeName}' already belongs to attribute set '{$attributeSetName}'.");
    }
}

$installer->endSetup();