<?php

class Crossroads_Retain24_Adminhtml_Retain24_ItemsController extends Mage_Adminhtml_Controller_Action
{
    public function emptyAction()
    {
        Mage::getSingleton("adminhtml/session")->addSuccess("Nothing done.");
        $pid = $this->getRequest()->getParam("id");
        $this->_redirect("adminhtml/sales_order/view", [ "order_id" => $pid ]);
    }

    public function issueAction()
    {
        $helper = Mage::helper("Retain24");
        $pid = $this->getRequest()->getParam("id");
        $order = Mage::getSingleton("sales/order")->load($pid);
        $itemIds = explode(",", $this->getRequest()->getPost("r24_items"));

        $adminUsername = "admin";
        $adminSession = Mage::getSingleton("admin/session");
        if ($adminSession) {
            $adminUser = $adminSession->getUser();
            if ($adminUser) {
                $adminUsername = $adminUser->getUsername();
            }
        }
        Mage::register("retain24_sent_by", $adminUsername);

        try {
            $itemList = $helper->getVoucherItemList($order);
            foreach ($itemList as $itemId => $itemData) {
                if (in_array($itemId, $itemIds)) {
                    $codes = Mage::getModel("Crossroads_Retain24/voucher")->getCollection()->addItemFilter($itemId);
                    $codeQty = count($codes);
                    if ($codeQty < $itemData["qty"]) {
                        $qtyToPurchase = $itemData["qty"] - $codeQty;
                        $helper->purchase_voucher($order, $itemId, $qtyToPurchase);
                    }
                }
            }

            $comment = Mage::registry("retain24_order_comment");
            if (!empty($comment)) {
                $history = $order->addStatusHistoryComment($comment);
                $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
                $order->save();
                Mage::getSingleton("adminhtml/session")->addSuccess($comment);
            }
        } catch (Exception $ex) {
            Mage::getSingleton("adminhtml/session")->addError("Exception: {$ex->getMessage()}");
        }

        $this->_redirect("adminhtml/sales_order/view", [ "order_id" => $pid ]);

    }

    public function emailAction()
    {
        $helper = Mage::helper("Retain24");
        $pid = $this->getRequest()->getParam("id");
        $order = Mage::getSingleton("sales/order")->load($pid);
        $storeId = $order->getStoreId();
        $itemIds = explode(",", $this->getRequest()->getPost("r24_items"));

        $adminUsername = "admin";
        $adminSession = Mage::getSingleton("admin/session");
        if ($adminSession) {
            $adminUser = $adminSession->getUser();
            if ($adminUser) {
                $adminUsername = $adminUser->getUsername();
            }
        }
        Mage::register("retain24_sent_by", $adminUsername);

        $appEmulation = Mage::getSingleton("core/app_emulation");
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);

        try {
            $itemList = $helper->getVoucherItemList($order);
            foreach ($itemList as $itemId => $itemData) {
                if (in_array($itemId, $itemIds)) {
                    $codes = Mage::getModel("Crossroads_Retain24/voucher")->getCollection()->addItemFilter($itemId);
                    $codeQty = count($codes);
                    if ($codeQty > 0) {
                        $helper->sendCustomerEmailForItem($order, $itemData);
                    }
                }
            }

            $comment = Mage::registry("retain24_order_comment");
            if (!empty($comment)) {
                $history = $order->addStatusHistoryComment($comment);
                $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
                $order->save();
                Mage::getSingleton("adminhtml/session")->addSuccess($comment);
            }
        } catch (Exception $ex) {
            Mage::getSingleton("adminhtml/session")->addError("Exception: {$ex->getMessage()}");
        }

        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
        $this->_redirect("adminhtml/sales_order/view", [ "order_id" => $pid ]);

    }

    public function recreateAction()
    {
        $helper = Mage::helper("Retain24");
        $pid = $this->getRequest()->getParam("id");
        $order = Mage::getSingleton("sales/order")->load($pid);
        $storeId = $order->getStoreId();

        $params = explode(":", $this->getRequest()->getPost("r24_items"));
        $wantedItemId = intval($params[0] ?? 0);
        $wantedVoucherId = intval($params[1] ?? 0);
        if (empty($wantedItemId) || empty($wantedVoucherId)) {
            Mage::getSingleton("adminhtml/session")->addError("Unknown parameters!");
            $this->_redirect("adminhtml/sales_order/view", [ "order_id" => $pid ]);
            return;
        }

        $adminUsername = "admin";
        $adminSession = Mage::getSingleton("admin/session");
        if ($adminSession) {
            $adminUser = $adminSession->getUser();
            if ($adminUser) {
                $adminUsername = $adminUser->getUsername();
            }
        }
        Mage::register("retain24_sent_by", $adminUsername);

        $appEmulation = Mage::getSingleton("core/app_emulation");
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);

        try {
            $itemList = $helper->getVoucherItemList($order);
            foreach ($itemList as $itemId => $itemData) {
                if ($itemId == $wantedItemId) {
                    $codes = Mage::getModel("Crossroads_Retain24/voucher")->getCollection()->addItemFilter($wantedItemId);
                    foreach ($codes as $code) {
                        if ($code["entity_id"] == $wantedVoucherId) {
                            $helper->createCodeImage($wantedVoucherId, $itemData, ["MULTICODE" => $code["voucher_code"]]);
                            Mage::getSingleton("adminhtml/session")->addSuccess("Successfully (re)created image for code.");
                            break 2;
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            Mage::getSingleton("adminhtml/session")->addError("Exception: {$ex->getMessage()}");
        }

        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
        $this->_redirect("adminhtml/sales_order/view", [ "order_id" => $pid ]);
    }

}
