<?php

class Crossroads_Retain24_Shell_Install {
    protected $_includeMage = false;

    protected $_products = [
        [
            'sku' => 'test-retain24-barcode',
            'name' => 'Test Retain24 barcode',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_BARCODE,
        ],
        [
            'sku' => 'test-retain24-qrcode',
            'name' => 'Test Retain24 qrcode',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_QRCODE,
        ],
        [
            'sku' => 'test-retain24-azteccode',
            'name' => 'Test Retain24 azteccode',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_AZTECCODE,
        ],
        [
            'sku' => 'test-retain24-barcode-128c',
            'name' => 'Test Retain24 barcode 128C',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_BARCODE128C,
        ],
    ];

    public function run() {
        $attribute_set_id = Mage::getModel('eav/entity_attribute_set')
            ->getCollection()
            ->addFieldToFilter('attribute_set_name', 'Retain24')
            ->getFirstItem()
            ->getId();

        foreach ($this->_products as $product) {
            $model = Mage::getModel('catalog/product');

            if ($entityId = $model->getIdBySku($product['sku'])) {
                $model->load($entityId);
            }

            $model->addData([
                "store_id" => Mage::app()->getStore()->getId(),
                "website_ids" => [Mage::app()->getStore()->getWebsiteId()],
                "attribute_set_id" => $attribute_set_id,
                "type_id" => "virtual",
                "sku" => $product['sku'],
                "name" => $product['name'],
                //"manufacturer" => $manufacturer,
                "status" => Mage_Catalog_Model_Product_Status::STATUS_ENABLED,
                "tax_class_id" => 2, // Taxable goods, always id 2
                "visibility" => Mage_Catalog_Model_Product_Visibility::VISIBILITY_BOTH,
                "price" => 12.34,
                "description" => "The long product description",
                "short_description" => "The shortest product description",
                "is_retain24_product" => 1, // Retain24 enabled
                "serial_code_image_type" => $product['image_type'],
            ]);
            $model->save();
        }
    }
}