<?php

class Crossroads_PurchaseLimiter_Block_Array extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{
    public function __construct()
    {
        $this->addColumn("sku", [
            "label" => Mage::helper("crossroads_purchaselimiter")->__("SKU"),
            "style" => "width:350px",
        ]);

        $this->_addButtonLabel = Mage::helper("crossroads_purchaselimiter")->__("Add SKU");

        parent::__construct();

        $this->setTemplate("crossroads_purchaselimiter/array_select.phtml");
    }

    public function mkGridId() {
        return $this->getHtmlId() ? $this->getHtmlId() : "_" . uniqid();
    }

    public function getArrayRows()
    {
        $element = $this->getElement();

        if (!$element->getValue() || !is_array($element->getValue())) {
            return [];
        }

        return array_values(array_map(function($row) {
            return new Varien_Object($row);
        }, $element->getValue()));
    }
}
