<?php

/**
 * Used to create select source for order status.
 */
class Crossroads_PurchaseLimiter_Model_Source_EventSelector
{
    /**
     * Options getter.
     * @return array
     */
    public function toOptionArray(): array
    {
        $options = [];
        foreach ($this->toArray() as $key => $name) {
            $options[] = ['value' => $key, 'label' => $name];
        }
        return $options;
    }

    /**
     * Get options in "key-value" format.
     * @return array
     */
    public function toArray(): array
    {
        $helper = Mage::helper('crossroads_purchaselimiter');
        return [
            'checkout' => $helper->__('On checkout'),
            'cartChange' => $helper->__('On cart change'),
        ];
    }
}
