<?php

class Crossroads_PurchaseLimiter_Model_Observer extends Mage_Core_Model_Abstract {

    public function quoteSubmitBefore(Varien_Event_Observer $observer): void
    {
        $helper = Mage::helper("crossroads_purchaselimiter");
        $quote = $observer->getQuote();
        $store = $quote->getStore();

        if (!$helper->isEnabled($store)) {
            return;
        }

        $this->verifyQuote($quote);
    }

    public function quoteSaveBefore(Varien_Event_Observer $observer): void
    {
        $helper = Mage::helper("crossroads_purchaselimiter");
        $quote = $observer->getQuote();
        $store = $quote->getStore();

        if (!$helper->isEnabled($store) || !$helper->onCartChange($store)) {
            return;
        }

        $this->verifyQuote($quote);
    }

    private function verifyQuote(Mage_Sales_Model_Quote $quote): void
    {
        $helper = Mage::helper("crossroads_purchaselimiter");
        $model = Mage::getModel("crossroads_purchaselimiter/order");
        $store = $quote->getStore();
        $exceeded = $model->getLimitExceedingItems($store, $quote->getCustomerId() ?: null, $quote);

        if (empty($exceeded)) {
            return; // All ok
        }

        // Log them
        foreach ($exceeded as $e) {
            Mage::log(sprintf(
                "PurchaseLimiter: Attempt to exceed %s purchase limit of %s on sku '%s' with %s for customer %d in store %d.",
                $e["mode"],
                $e["limit"],
                implode("', '", $e["skus"]),
                $e["req"] - $e["limit"],
                $quote->getCustomerId(),
                $store->getId()
            ));
        }

        throw new Crossroads_PurchaseLimiter_Exception($helper->__("Attempt to exceed purhcase limit."));
    }
}
