<?php

class Crossroads_PurchaseLimiter_Helper_Data extends Mage_Core_Helper_Abstract {
    const CONFIG_ENABLED  = "crossroads_purchaselimiter/general/enabled";
    const CONFIG_ON_EVENT = "crossroads_purchaselimiter/limits/on_event";
    const CONFIG_DURATION = "crossroads_purchaselimiter/limits/duration";
    const CONFIG_LIMITS   = "crossroads_purchaselimiter/limits/limits";

    public function isEnabled($store = null) {
        if( ! $store) {
            $store = Mage::app()->getStore();
        }

        return (boolean)$store->getConfig(self::CONFIG_ENABLED);
    }

    public function onCartChange($store = null) {
        if( ! $store) {
            $store = Mage::app()->getStore();
        }

        return $store->getConfig(self::CONFIG_ON_EVENT) == 'cartChange';
    }

    public function getLimitedSkus($store = null) {
        if( ! $store) {
            $store = Mage::app()->getStore();
        }

        $config = unserialize($store->getConfig(self::CONFIG_LIMITS));

        return array_values(array_filter(array_map(function($l) {
            if( ! is_array($l)) {
                return null;
            }

            foreach(["limit", "skus", "mode"] as $k) {
                if( ! array_key_exists($k, $l) || ! is_scalar($l[$k]) || ! strlen(trim($l[$k]))) {
                    return null;
                }
            }

            return [
                "skus"  => array_filter(array_map("trim", explode(",", $l["skus"]))),
                "limit" => (double)$l["limit"],
                "mode"  => $l["mode"],
            ];
        }, $config ?: [])));
    }
}
