<?php

class Crossroads_PurchaseLimiter_Block_Date
    extends Mage_Adminhtml_Block_Abstract implements Varien_Data_Form_Element_Renderer_Interface
{
    /**
     * Render element html
     *
     * @param Varien_Data_Form_Element_Abstract $element
     * @return string
     */
    public function render(Varien_Data_Form_Element_Abstract $element) {
        $duration = Mage::getSingleton("adminhtml/config_data")->getConfigDataValue(Crossroads_PurchaseLimiter_Helper_Data::CONFIG_DURATION) ?: 0;

        $date = @date("Y-m-d", @strtotime("-".$duration));

        return sprintf('<tr class="system-fieldset-sub-head" id="row_%s"><td>%s</td><td>%s<p class="note">%s</p></td><td colspan="3"></td></tr>',
            $element->getHtmlId(),
            $this->__("Considering orders from"),
            $date,
            "Preview of the date from which orders will be considered when calculating older purchases. Obtained using the current date and the value from ".$this->__("Duration").", reload for updates."
        );
    }
}
