<?php

class Crossroads_PurchaseLimiter_Model_Observer extends Mage_Core_Model_Abstract {
    public function quoteSubmitBefore($observer) {
        $helper = Mage::helper("crossroads_purchaselimiter");
        $model  = Mage::getModel("crossroads_purchaselimiter/order");
        $order  = $observer->getOrder();
        $quote  = $observer->getQuote();
        $store  = $quote->getStore();

        if( ! $helper->isEnabled($store)) {
            return;
        }

        $exceeded = $model->getLimitExceedingItems($store, $quote->getCustomerId() ?: null, $quote);

        if(empty($exceeded)) {
            // All ok
            return;
        }

        // Log them
        foreach($exceeded as $e) {
            Mage::log(sprintf(
                "PurchaseLimiter: Attempt to exceed %s purchase limit of %s on sku '%s' with %s for customer %d in store %d.",
                $e["mode"],
                $e["limit"],
                implode("', '", $e["skus"]),
                $e["req"] - $e["limit"],
                $quote->getCustomerId(),
                $store->getId()
            ));
        }

        if(Mage::helper("core")->isModuleEnabled("Crossroads_API")) {
            throw Crossroads_API_ResponseException::create(403, "Attempt to exceed purchase limit.", [
                "exceededLimits" => array_map(function($e) {
                    return [
                        "skus"   => $e["skus"],
                        "limit"  => (double)$e["limit"],
                        // QTY or ROW_TOTAL
                        "mode"   => $e["mode"],
                        "excess" => (double)($e["req"] - $e["limit"]),
                    ];
                }, $exceeded),
            ], 14001);
        }

        Mage::throwException($helper->__("Attempt to exceed purhcase limit."));
    }
}
