<?php

declare(strict_types=1);

namespace Crossroads\PsalmPluginMagento;

use PhpParser\NodeTraverser;
use Psalm\Codebase;
use Psalm\Internal\Scanner\FileScanner;
use Psalm\Progress\Progress;
use Psalm\Storage\FileStorage;

/**
 * Scan the loaded file and add any indirectly referenced classes to the queue.
 */
class Scanner extends FileScanner {
    /**
     * @param bool $storage_from_cache
     */
    public function scan(
        Codebase $codebase,
        FileStorage $file_storage,
        $storage_from_cache = false,
        Progress $progress = null
    ): void {
        parent::scan($codebase, $file_storage, $storage_from_cache, $progress);

        $stmts = $codebase->getStatementsForFile($file_storage->file_path);

        $traverser = new NodeTraverser();
        $traverser->addVisitor(
            new Visitor($codebase->scanner, $file_storage->file_path)
        );

        $traverser->traverse($stmts);
    }
}
