<?php

declare(strict_types=1);

namespace Crossroads\PsalmPluginMagento;

use PhpParser\NodeTraverser;
use Psalm\Codebase;
use Psalm\Internal\Scanner\FileScanner;
use Psalm\Progress\Progress;
use Psalm\Storage\FileStorage;

/**
 * Scan the loaded file and add any indirectly referenced classes to the queue.
 */
class Scanner extends FileScanner {
    public function scan(
        Codebase $codebase,
        FileStorage $fileStorage,
        $storageFromCache = false,
        Progress $progress = null
    ) {
        parent::scan($codebase, $fileStorage, $storageFromCache, $progress);

        $stmts = $codebase->statements_provider->getStatementsForFile(
            $fileStorage->file_path,
            $progress
        );

        $traverser = new NodeTraverser();
        $traverser->addVisitor(
            new Visitor($codebase->scanner, $fileStorage->file_path)
        );

        $traverser->traverse($stmts);
    }
}
