<?php

declare(strict_types=1);

namespace Crossroads\PsalmPluginMagento;

use PhpParser\Node\Expr;
use PhpParser\Node\Expr\StaticCall;
use PhpParser\Node\Name;
use PhpParser\Node\Scalar\String_;
use Psalm\Codebase;
use Psalm\Context;
use Psalm\FileManipulation;
use Psalm\Plugin\Hook\AfterMethodCallAnalysisInterface;
use Psalm\Plugin\PluginEntryPointInterface;
use Psalm\Plugin\RegistrationInterface;
use Psalm\StatementsSource;
use Psalm\Type\Atomic\TNamedObject;
use Psalm\Type\Union;
use SimpleXMLElement;

/**
 * Finds instances of Mage::getModel, Mage::getSingleton, Mage::getHelper
 * and updates their return types to a more specific type.
 */
class Plugin
    implements
    AfterMethodCallAnalysisInterface,
    PluginEntryPointInterface
{
    public function __invoke(RegistrationInterface $psalm, ?SimpleXMLElement $config = null) {
        $psalm->addStubFile(MagentoClassFinder::findMageFile());
        $psalm->registerHooksFromClass(self::class);
    }

    /**
     * @param  FileManipulation[] $file_replacements
     *
     * @return void
     */
    public static function afterMethodCallAnalysis(
        Expr $node,
        string $methodId,
        string $appearingMethodId,
        string $declaringMethodId,
        Context $context,
        StatementsSource $statementsSource,
        Codebase $codebase,
        array &$fileReplacements = [],
        Union &$returnTypeCandidate = null
    ) {
        if ($node instanceof StaticCall
            && $node->class instanceof Name
            && (string)$node->class === "Mage"
        ) {
            $candidate = null;
            $firstArg = count($node->args) > 0 ? $node->args[0]->value : null;

            if ($firstArg instanceof String_) {
                // TODO: Add more static methods
                switch((string)$node->name) {
                case "getSingleton":
                case "getModel":
                    $candidate = MagentoClassFinder::findCandidate($firstArg->value, "model");
                    $returnTypeCandidate = new Union([new TNamedObject($candidate)]);
                    break;

                case "helper":
                    $candidate = MagentoClassFinder::findCandidate($firstArg->value, "helper");
                    $returnTypeCandidate = new Union([new TNamedObject($candidate)]);
                    break;
                }
            }
        }
    }
}
