<?php
// http://sarahessex.co.uk/blog/tutorial-adding-attribute-magento-products-grid-admin/


class Crossroads_ProductGrid_Block_Adminhtml_Catalog_Product_Grid extends Mage_Adminhtml_Block_Catalog_Product_Grid
{
    public function setCollection($collection) {
        $store = Mage::app()->getStore();

        if ($store->getId() && !isset($this->_joinAttributes['manufacturer'])) {
            $collection->joinAttribute(
                'manufacturer',
                'catalog_product/manufacturer',
                'entity_id',
                null,
                'left',
                $store->getId()
            );
        } else {
            $collection->addAttributeToSelect('manufacturer');
        }

        parent::setCollection($collection);
    }

    protected function _prepareColumns() {
        $store = $this->_getStore();

        $this->addColumnAfter('manufacturer',
            [
                'header'=> Mage::helper('catalog')->__('Manufacturer'),
                'width' => '100px',
                'type'  => 'options',
                'index' => 'manufacturer',
                'options' => $this->getAttributeOptions('manufacturer')
            ],
            'sku');

        return parent::_prepareColumns();
    }

    protected function getAttributeOptions($_attributeCode) {
        $options = [];

        // todo: only select the specified attribute
        $collection = Mage::getModel('eav/entity_attribute_option')->getCollection()
            ->setStoreFilter()
            ->join('attribute','attribute.attribute_id=main_table.attribute_id', 'attribute_code');

        foreach ($collection as $option) {
            if ($option->getAttributeCode() == $_attributeCode) {
                $options[$option->getOptionId()] = $option->getValue();
            }
        }

        return $options;

    }

}
