<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;

use Points\Core\Currency;

class QuoteShippingCurrency {
    /**
     * @var Currency
     */
    protected $currency;

    /**
     * @param array{currency:Currency} $amounts
     */
    public function __construct(
        array $amounts
    ) {
        $this->currency = $amounts["currency"];
    }

    public function getMin(): MageQL_Core_Model_Price_Abstract {
        $included = $this->currency->getIncluded();

        return new QuoteCurrencyTotal(
            $included ? 0 : $this->currency->getValue(),
            $this->currency->getValueIncludesTax(),
            $included ? 0 : $this->currency->getTax()
        );
    }

    public function getMax(): MageQL_Core_Model_Price_Abstract {
        return new QuoteCurrencyTotal(
            $this->currency->getValue(),
            $this->currency->getValueIncludesTax(),
            $this->currency->getTax()
        );
    }

    public function getValue(): MageQL_Core_Model_Price_Abstract {
        return new QuoteCurrencyTotal(
            $this->currency->getValue(),
            $this->currency->getValueIncludesTax(),
            $this->currency->getTax()
        );
    }
}
