<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;
use MageQL_Core_Model_Price_Abstract;

use Points\Core\Currency;
use Points\Core\Extension\Quote as QuoteExt;
use Points\Core\Extension\QuoteAddress as AddressExt;

class QuoteSelectedShippingCurrency extends QuoteShippingCurrency {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param array{currency:Currency} $amounts
     * @param QuoteExt $quote
     */
    public function __construct(
        array $amounts,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($amounts);

        $this->quote = $quote;
    }

    public function getRemaining(): MageQL_Core_Model_Price_Abstract {
        /**
         * @var AddressExt
         */
        $shipping = $this->quote->getShippingAddress();

        return new QuoteCurrencyTotal(
            abs($shipping->getShippingAmount() +
            $shipping->getShippingHiddenTaxAmount() -
            $shipping->getShippingDiscountAmount() -
            $shipping->getPointsShippingTotal()),
            false,
            abs($shipping->getShippingTaxAmount() -
            $shipping->getPointsShippingTaxTotal())
        );
    }
}
