<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\Amount;
use Points\Core\Total\PointsInterface;

class QuoteSelectedShippingPoints extends QuoteShippingPoints {
    /**
     * @var Mage_Sales_Model_Quote
     */
    protected $quote;

    /**
     * @param PointsInterface<int> $points
     */
    public function __construct(
        PointsInterface $points,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($points);

        $this->quote = $quote;
    }

    public function getSelected(): TotalInterface {
        return new PointsTotal(new Amount(
            (int)$this->quote->getPointsShippingPoints(),
            false,
            (int)$this->quote->getPointsShippingTaxPoints()
        ));
    }
}
