<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote_Item;
use MageQL_Catalog_Model_Product_Price;
use Mage_Catalog_Model_Product;

use Points\Core\Total\Item;

class QuoteItemPoints {
    /**
     * @var Item<int>
     */
    protected $totals;

    /**
     * @param Item<int> $totals
     */
    public function __construct(Item $totals) {
        $this->totals = $totals;
    }

    public function getMin(): TotalInterface {
        $points = $this->totals->getPoints();

        assert($points !== null);

        return new PointsTotal($points->getMin());
    }

    public function getMax(): TotalInterface {
        $points = $this->totals->getPoints();

        assert($points !== null);

        return new PointsTotal($points->getMax());
    }

    public function getValue(): TotalInterface {
        $points = $this->totals->getPoints();

        assert($points !== null);

        return new PointsTotal($points->getValue());
    }
}
