<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$conn->modifyColumn($this->getTable("points_core/limit_order"), "max_value", [
    "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
    "unsigned" => true,
    "nullable" => true,
    "default" => null,
    "comment" => "Max point value to spend per order",
]);

$conn->modifyColumn($this->getTable("points_core/limit_order"), "max_percent", [
    "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
    "unsigned" => true,
    "nullable" => true,
    "default" => null,
    "comment" => "Max point value as a percentage of the order to spend per order",
]);

$installer->endSetup();
