<?php

declare(strict_types=1);

namespace Points\Core\Total;

use Mage_Tax_Model_Config;
use Points_Core_Model_Product_Price;
use Points\Core\Amount;
use Points\Core\Extension\QuoteAddressItem;

/**
 * A Static point instance with rounding errors spread out using Calculator::spreadTotals.
 *
 * @implements PointsInterface<int>
 */
class SpreadPoints implements PointsInterface {
    private $value;
    private $min;
    private $max;
    private $discount;

    /**
     * @param Amount<int> $value
     * @param Amount<int> $min
     * @param Amount<int> $max
     * @param Amount<int> $discount
     */
    public function __construct(
        Amount $value,
        Amount $min,
        Amount $max,
        Amount $discount
    ) {
        $this->value = $value;
        $this->min = $min;
        $this->max = $max;
        $this->discount = $discount;
    }

    public function getValue(): Amount {
        return $this->value;
    }

    public function getMin(): Amount {
        return $this->min;
    }

    public function getMax(): Amount {
        return $this->max;
    }

    public function getDiscount(): Amount {
        return $this->discount;
    }
}
