<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\QuoteAddressTotal;
use Points\Core\Points;
use Points\Core\Currency;
use Points\Core\Extension\Quote as QuoteExt;
use Points\Core\Total\Shipping;

class QuoteSelectedShipping extends QuoteShipping {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param Shipping<int> $total
     * @param QuoteExt $quote
     */
    public function __construct(
        Shipping $total,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($total);

        $this->quote = $quote;
    }

    public function getPoints(): ?QuoteShippingPoints {
        $points = $this->total->getPoints();

        if( ! $points) {
            return null;
        }

        return new QuoteSelectedShippingPoints($points, $this->quote);
    }

    public function getCurrency(): QuoteShippingCurrency {
        return new QuoteSelectedShippingCurrency($this->total, $this->quote);
    }
}
