<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Tax_Model_Config;
use MageQL_Core_Model_Context;
use Mage_Sales_Model_Quote;

use Points\Core\Amount;
use Points\Core\ProviderInterface;
use Points\Core\QuoteAddressTotal;
use Points\Core\Extension\Quote as QuoteExt;

class QuoteSelectedPoints extends QuotePoints {
    public function getSelected(): TotalInterface {
        return new PointsTotal(new Amount(
            (int)$this->quote->getPointsPoints(),
            false,
            (int)$this->quote->getPointsTaxPoints()
        ));
    }
}
