<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote_Item;
use MageQL_Catalog_Model_Product_Price;
use Mage_Catalog_Model_Product;

use Points\Core\QuoteAddressTotal;
use Points\Core\Extension\QuoteItem;
use Points\Core\Total\Item;
use Points\Core\Amount;

class QuoteItemSelectedPoints extends QuoteItemPoints {
    /**
     * @var QuoteItem
     */
    protected $item;

    /**
     * @param Item<int> $totals
     * @param QuoteItem $item
     */
    public function __construct(Item $totals, Mage_Sales_Model_Quote_Item $item) {
        parent::__construct($totals);

        $this->item = $item;
    }

    public function getSelected(): TotalInterface {
        return new PointsTotal(new Amount(
            (int)$this->item->getPointsRowPoints(),
            false,
            (int)$this->item->getPointsRowTaxPoints()
        ));
    }
}
