<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;
use Mage_Sales_Model_Order;

use Points\Core\Amount;
use Points\Core\Extension\Order as OrderExt;

class OrderSelectedShipping {
    /**
     * @var OrderExt
     */
    protected $order;

    /**
     * @param OrderExt $order
     */
    public function __construct(
        Mage_Sales_Model_Order $order
    ) {
        $this->order = $order;
    }

    public function getPoints(): TotalInterface {
        return new PointsTotal(new Amount(
            (int)$this->order->getPointsShippingPoints(),
            false,
            (int)$this->order->getPointsShippingTaxPoints()
        ));
    }

    public function getCurrency(): MageQL_Core_Model_Price_Abstract {
        return new CurrencyTotal(new Amount(
            $this->order->getShippingAmount() - $this->order->getPointsShippingTotal(),
            false,
            $this->order->getShippingTaxAmount() - $this->order->getPointsShippingTaxTotal()
        ));
    }
}
