<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;
use MageQL_Core_Model_Price_Abstract;

use Points\Core\Amount;
use Points\Core\Currency;
use Points\Core\Total\Shipping;
use Points\Core\Extension\Quote as QuoteExt;
use Points\Core\Extension\QuoteAddress as AddressExt;

class QuoteSelectedShippingCurrency extends QuoteShippingCurrency {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param Shipping<int> $shipping
     * @param QuoteExt $quote
     */
    public function __construct(Shipping $shipping, Mage_Sales_Model_Quote $quote) {
        parent::__construct($shipping);

        $this->quote = $quote;
    }

    public function getRemaining(): MageQL_Core_Model_Price_Abstract {
        $shipping = $this->quote->getShippingAddress();

        return new CurrencyTotal(new Amount(
            abs($shipping->getShippingAmount() +
            $shipping->getShippingHiddenTaxAmount() -
            $shipping->getShippingDiscountAmount() -
            $shipping->getPointsShippingTotal()),
            false,
            abs($shipping->getShippingTaxAmount() -
            $shipping->getPointsShippingTaxTotal())
        ));
    }
}
