<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\Amount;
use Points\Core\Currency;
use Points\Core\Points;
use Points\Core\Extension\Quote as QuoteExt;
use Points\Core\Total\QuoteAddress;

class QuoteSelectedDiscountPoints extends QuoteDiscountPoints {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param QuoteExt $quote
     */
    public function __construct(
        QuoteAddress $total,
        QuotePoints $points,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($total, $points);

        $this->quote = $quote;
    }

    public function getSelected(): TotalInterface {
        return new PointsTotal(new Amount(
            (int)$this->quote->getPointsDiscountPoints(),
            false,
            (int)$this->quote->getPointsDiscountTaxPoints()
        ));
    }
}
