<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\Points;
use Points\Core\Currency;
use Points\Core\Extension\Quote as QuoteExt;
use Points\Core\Total\QuoteAddress;

class QuoteSelectedDiscount extends QuoteDiscount {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param QuoteExt $quote
     */
    public function __construct(
        QuoteAddress $total,
        QuotePoints $points,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($total, $points);

        $this->quote = $quote;
    }

    public function getPoints(): QuoteDiscountPoints {
        return new QuoteSelectedDiscountPoints($this->total, $this->points, $this->quote);
    }

    public function getCurrency(): QuoteDiscountCurrency {
        return new QuoteSelectedDiscountCurrency($this->total, $this->points, $this->quote);
    }
}
