<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\Total\QuoteAddress;

class QuoteDiscount {
    /**
     * @var QuoteAddress
     */
    protected $total;
    /**
     * @var QuotePoints
     */
    protected $points;

    public function __construct(QuoteAddress $total, QuotePoints $points) {
        $this->total = $total;
        $this->points = $points;
    }

    public function getPoints(): QuoteDiscountPoints {
        return new QuoteDiscountPoints($this->total, $this->points);
    }

    public function getCurrency(): QuoteDiscountCurrency {
        return new QuoteDiscountCurrency($this->total, $this->points);
    }
}
