<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Context;
use MageQL_Core_Model_Price_Abstract;
use Mage_Sales_Model_Order;

use Points\Core\Amount;
use Points\Core\ProviderInterface;
use Points\Core\Extension\Order as OrderExt;

class OrderSelected {
    /**
     * @var string
     */
    protected $type;

    /**
     * @var ?ProviderInterface
     */
    protected $provider;

    /**
     * @var OrderExt
     */
    protected $order;

    /**
     * @param OrderExt $order
     */
    public function __construct(
        Mage_Sales_Model_Order $order,
        string $type,
        ProviderInterface $provider = null
    ) {
        $this->type = $type;
        $this->provider = $provider;
        $this->order = $order;
    }

    public function getId(): string {
        return $this->type;
    }

    public function getLabel(array $args, MageQL_Core_Model_Context $ctx): ?string {
        return $this->provider ? $this->provider->getLabel($ctx->getStore()) : null;
    }

    public function getPoints(): TotalInterface {
        return new PointsTotal(new Amount(
            (int)$this->order->getPointsPoints(),
            false,
            (int)$this->order->getPointsTaxPoints()
        ));
    }

    public function getCurrency(): MageQL_Core_Model_Price_Abstract {
        return new CurrencyTotal(new Amount(
            (float)$this->order->getGrandTotal(),
            true,
            (float)$this->order->getTaxAmount()
        ));
    }

    public function getDiscount(): ?OrderSelectedDiscount {
        if($this->order->getDiscountAmount() > 0) {
            return new OrderSelectedDiscount($this->order);
        }

        return null;
    }

    public function getShipping(): ?OrderSelectedShipping {
        if($this->order->getIsVirtual()) {
            return null;
        }

        return new OrderSelectedShipping($this->order);
    }
}
