<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$itemColumns = [
    "points_row_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Number of points spent on this row, excluding tax",
    ],
    "points_row_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Number of points spent on this row in tax",
    ],
    "points_row_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points spent cover, excluding tax",
    ],
    "points_row_tax_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points spent cover in tax",
    ],
    "base_points_row_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points spent cover, excluding tax",
    ],
    "base_points_row_tax_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points spent cover in tax",
    ],
];

foreach($itemColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/quote_item"), $col, $spec);
    $conn->addColumn($this->getTable("sales/order_item"), $col, $spec);
}

$quoteColumns = [
    "points_shipping_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Number of points spent on shipping, excluding tax",
    ],
    "points_shipping_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Number of points spent on shipping in tax",
    ],
    "points_shipping_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points spent cover, excluding tax",
    ],
    "points_shipping_tax_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points spent cover in tax",
    ],
    "base_points_shipping_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points spent cover, excluding tax",
    ],
    "base_points_shipping_tax_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points spent cover in tax",
    ],
];

foreach($quoteColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/quote_address"), $col, $spec);
    $conn->addColumn($this->getTable("sales/quote"), $col, $spec);
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

$installer->endSetup();
