<?php

declare(strict_types=1);

class Points_Core_Model_Resource_Product_Price extends Mage_Core_Model_Resource_Db_Abstract {
    public function __construct() {
        $this->_init("points_core/product_price", "entity_id");
    }

    protected function _construct(): void {
    }

    /**
     * @param int $customerGroupId
     */
    public function loadByStoreProductTypeCustomerGroupId(
        Points_Core_Model_Product_Price $price,
        Mage_Core_Model_Store $store,
        Mage_Catalog_Model_Product $product,
        string $type,
        $customerGroupId
    ): void {
        $adapter = $this->_getReadAdapter();
        $bind = [
            "store_id" => $store->getId(),
            "product_id" => $product->getId(),
            "type" => $type,
            "customer_group_id" => $customerGroupId,
        ];

        $select = $adapter->select()
            ->from($this->getTable("points_core/product_price"), ["entity_id"])
            ->where("product_id = :product_id AND store_id = :store_id AND type = :type AND customer_group_id = :customer_group_id");

        $entityId = $adapter->fetchOne($select, $bind);

        if($entityId) {
            $this->load($price, $entityId);
        }
        else {
            $price->setData([]);
        }
    }

    /**
     * @param int $customerGroupId
     * @return Array<Points_Core_Model_Product_Price>
     */
    public function getMatchingPrices(Mage_Core_Model_Store $store, $customerGroupId, string $type, array $productIds): array {
        $result = [];
        $collection = Mage::getResourceModel("points_core/product_price_collection");
        $select = $collection->getSelect();

        $select->where("type = ?", $type);
        $select->where("product_id IN (?)", $productIds);
        $select->where("store_id IN (0, ?)", $store->getId());
        $select->where("customer_group_id IN (?)", [Mage_Customer_Model_Group::NOT_LOGGED_IN_ID, $customerGroupId]);
        // Make sure we overwrite any 0 store with the more specific store, and take customer group into account
        $select->order(["store_id asc", "customer_group_id asc"]);

        foreach($collection as $c) {
            $result[$c->getProductId()] = $c;
        }

        return $result;
    }
}
