# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [3.7.3] - 2022-03-31
### Fixed
- Default values of maximums in order limit table are now null, indicating
  infinite maximum.
- `PointsQuoteCurrency`.`min` and `PointsQuoteCurrency`.`max` now respect
  order limits.

## [3.7.2] - 2022-01-31
### Fixed
- Minimum point price greater than point value caused products to be impossible to sell.

## [3.7.1] - 2021-12-16
### Fixed
- Parent configurable products not being reindexed when child product point
  prices are changed.

## [3.7.0] - 2021-10-27
### Added
- Option to bypass point requirement by setting `setBypassPointRequirement`
  right before the quote is submitted.

## [3.6.0] - 2021-08-25
### Added
- The indexed price of configurable products now respect the stock status of
  child products based on the "Display Out of Stock Products" setting.
### Changed
- The logic for required point payment for a product depends on the set point
  prices set for the product. If there all of them have a minimum price greater
  than zero the product requires a point payment to be used. 
### Removed
- `points_payment_required` product attribute.

## [3.5.0] - 2021-07-06
### Added
- `points_payment_required` attribute on products which require point payment
  to be used when they are present in the cart.
- `PointsCustomerBalance`.`pointsIncludeVat`
- `PointsSpendingLimit`.`includesVat`
- `includes_tax` flag to `points_limit_order` and `points_limit` total
  indicating if the limit is applied on a total including VAT or not.
- `PointsQuote`.`rejectionReasons` containing a list of reasons to why the
  quote is rejected from using point payment, if any.
### Fixed
- Ignore deleted items from quote when calculating total.
- Rounding error of currency covered by points in point calculation.
- Zero limits are no longer ignored in query responses.

## [3.4.1] - 2021-05-21
### Fixed
- Itemized point calculations for items and shipping should now work correctly
  with items which have minimum and/or maximum amount of points allowed.

## [3.4.0] - 2021-05-12
### Changed
- Apply order limits to `PointsQuotePoints` `min`, `max`, and `available`.
### Fixed
- Order limit minimum is now properly applied during total calculation.

## [3.3.2] - 2021-04-16
### Fixed
- `PointsQuotePoints`.`available` now takes the total spent limit into account.
- `PointsQuoteSelectedPoints`.`available` now takes the total spent limit into account.
- `PointsSpendingLimit`.`remaining` can no longer be negative, will always be 0 or greater.

## [3.3.1] - 2021-04-15
### Fixed
- `OrderSelectedShipping`.`points` returning the wrong value.

## [3.3.0] - 2021-04-14
### Added
- `ProviderInterface::getProductFallbackRate` now also has a product.

## [3.2.0] - 2021-04-14
### Changed
- `Points_Core_Heper_Data::getTypeProviders` no longer requires a `$store` parameter.
- `Points_Core_Heper_Data::getTypeProvider` no longer requires a `$store` parameter.
### Fixed
- Point calculation for configurable row items (GEN-682)

## [3.1.0] - 2021-04-07
### Added
- `quotePointsRemove` mutation which removes any point payment on the quote.

## [3.0.1] - 2021-04-01
### Changed
- Use quote as a parameter for cache.

## [3.0.0] - 2021-04-01
### Added
- `ProviderInterface`.`getProductFallbackRate` for fallback rates in product import.
- `QuoteItem`.`availablePointPayments`.
### Changed
- Renamed `PointsQuoteItem` to `PointsQuoteItemSelected`.
- Renamed `PointsQuoteItemCurrency` to `PointsQuoteItemSelectedCurrency`.
- Renamed `PointsQuoteItemPoints` to `PointsQuoteItemSelectedPoints`.

## [2.0.1] - 2021-03-30
### Fixed
- Shipping calculation values are now properly saved.

## [2.0.0] - 2021-03-09
### Added
- `ProductPointPaymentPrice`.`minimumCurrency` containing the minimum amount of
  currency to spend on the product if using point payment.
- `QuoteItemPointPayment`.`minimumCurrency` containing the minimum amount of
  currency to spend on the item for the selected point payment.
- Columns storing amount of points spent, and the value in currency, for items
  and shipping in quote and order.
- Minimum and maxium currency possible to spend.
- Current amount to spend in terms of both points and currency.
- Requires currency flag on Quote.
- Shipping as points.
- Discount as points.
### Changed
- Renamed several internal columns.
- Minimum point price is now affected by discounts.
- Refactored the GraphQL API.
- Renamed `Mutation`.`setQuotePointsPayment` to `quotePointsSet`.
- Renamed `Mutation`.`setQuotePointsPaymentToMaximum` to `quotePointsSetToMaximum`.

## [1.0.1] - 2021-02-08
### Fixed
- Adminhtml block loading crash when visiting sales/points.

## [1.0.0] - 2021-01-29
### Added
- Initial release.