<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Context;
use Mage_Sales_Model_Quote_Item;

use Points\Core\ProviderInterface;
use Points\Core\QuoteAddressTotal;
use Points\Core\Extension\QuoteItem as QuoteItemExtension;

class QuoteItem {
    /**
     * @var string
     */
    protected $type;

    /**
     * @var ProviderInterface
     */
    protected $provider;

    /**
     * @var QuoteAddressTotal
     */
    protected $totals;

    /**
     * @var QuoteItemExtension $item
     */
    protected $item;

    /**
     * @param QuoteItemExtension $item
     */
    public function __construct(
        string $type,
        ProviderInterface $provider,
        QuoteAddressTotal $totals,
        Mage_Sales_Model_Quote_Item $item
    ) {
        $this->type = $type;
        $this->provider = $provider;
        $this->totals = $totals;
        $this->item = $item;
    }

    public function getId(): string {
        return $this->type;
    }

    public function getLabel(
        array $args,
        MageQL_Core_Model_Context $ctx
    ): string {
        return $this->provider->getLabel($ctx->getStore());
    }

    public function getCurrencyRequired(): bool {
        $value = $this->totals->getRowPointsValue($this->item);
        $max = $this->totals->getRowPointsMax($this->item) ?? $value;

        return $max && $value ? $max->getTotalInclTax() < $value->getTotalInclTax() : false;
    }

    public function getPoints(): QuoteItemPoints {
        return new QuoteItemPoints($this->totals, $this->item);
    }

    public function getCurrency(): QuoteItemCurrency {
        return new QuoteItemCurrency($this->totals, $this->item);
    }
}
