<?php

use Points\Core\Extension\Product as ProductExt;

/**
 * Queries the point payment required status for a list of products.
 */
class Points_Core_Model_Product_PointsPaymentRequired {
    private static function getRegistryKey(
        Mage_Core_Model_Store $store,
        int $customerGroupId
    ): string {
        return sprintf("points_core_product_points_payment_required_%d_%d", $store->getId(), $customerGroupId);
    }

    /**
     * @param string|int $customerGroupId
     */
    public static function instance(Mage_Core_Model_Store $store, $customerGroupId): self {
        $key = self::getRegistryKey($store, (int)$customerGroupId);
        $instance = Mage::registry($key);

        if( ! $instance) {
            $instance = new self($store, (int)$customerGroupId);

            Mage::register($key, $instance);
        }

        return $instance;
    }

    /**
     * @var Array<int>
     */
    protected $productIds = [];

    /**
     * @var Array<int, bool>
     */
    protected $data = [];

    /**
     * @var Mage_Core_Model_Store
     */
    protected $store;

    /**
     * @var int
     */
    protected $customerGroupId;

    private function __construct(Mage_Core_Model_Store $store, int $customerGroupId) {
        $this->store = $store;
        $this->customerGroupId = $customerGroupId;
    }

    public function queue(Mage_Catalog_Model_Product $product): void {
        if( ! in_array($product->getId(), $this->productIds)) {
            $this->productIds[] = $product->getId();
        }
    }

    /**
     * @return bool
     */
    public function getPointsPaymentRequired(Mage_Catalog_Model_Product $product): bool {
        if( ! empty($this->productIds)) {
            $helper = Mage::helper("points_core");
            $priceResource = Mage::getResourceModel("points_core/product_price");
            $providers = $helper->getTypeProviders();

            // TODO: Use a single SQL query for this?
            // We have few active type providers so this should not be much of a
            // performance-concern
            foreach(array_keys($providers) as $type) {
                $matchingPrices = $priceResource->getMatchingPrices($this->store, $this->customerGroupId, $type, $this->productIds);

                foreach($matchingPrices as $price) {
                    // overwrite with true
                    $this->data[(int)$price->getProductId()] =
                        ($this->data[(int)$price->getProductId()] ?? false) ||
                        $price->isRequired();
                }
            }

            $this->productIds = [];
        }

        if(array_key_exists($product->getId(), $this->data)) {
            return $this->data[$product->getId()];
        }

        return false;
    }
}

